/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import oz.viewer.ui.main.overlay.AButtonInfo$AButtonInfoOnClickListener;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.OZOverlayView;

public class AButtonInfo
implements Comparable {
    private int mIndex;
    private int mCommand;
    private boolean mEnabled;
    private int mVisibility;
    private ImageButton mButton;
    private OZOverlayView mParent;
    private AButtonInfo$AButtonInfoOnClickListener mOnClickListener;

    public AButtonInfo(OZOverlayView oZOverlayView, int n, int n2) {
        this.mParent = oZOverlayView;
        this.mIndex = n;
        this.mCommand = n2;
        this.mEnabled = true;
        this.mVisibility = 0;
        this.mOnClickListener = new AButtonInfo$AButtonInfoOnClickListener(this);
    }

    public OZOverlayView getParent() {
        return this.mParent;
    }

    public void setIndex(int n) {
        if (this.mIndex != n) {
            this.mIndex = n;
            this.removeButton();
            this.getParent().requestNeedUpdateView();
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getCommand() {
        return this.mCommand;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
        this.updateButton();
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public void setVisibility(int n) {
        this.mVisibility = n;
    }

    public void show() {
        this.setVisibility(0);
        this.updateButton();
    }

    public void hide() {
        this.setVisibility(8);
        this.updateButton();
    }

    protected String getImagesPath() {
        return null;
    }

    protected void initButtonInternal(ImageButton imageButton) {
    }

    protected void initButton() {
        this.getButton().setBackgroundColor(0);
        this.getButton().setOnClickListener((View.OnClickListener)this.mOnClickListener);
        int n = AOverlayUtil.DpToPx(5);
        this.initButtonImage(this.getButton());
        this.getButton().setPadding(n, n * 2, n, n * 2);
        this.initButtonInternal(this.getButton());
        this.updateButton();
    }

    protected void initButtonImage(ImageButton imageButton) {
        imageButton.setImageDrawable(AOverlayUtil.getAssetIcon_Toolbar(imageButton.getContext(), this.getImagesPath()));
    }

    protected void updateButtonInternal() {
    }

    protected void updateButton() {
        if (this.getButton() != null) {
            this.updateButtonInternal();
            if (this.getButton().isEnabled() != this.isEnabled()) {
                this.getButton().setEnabled(this.isEnabled());
                this.updateButtonEnable(this.getButton());
            }
            if (this.getButton().getVisibility() != this.getVisibility()) {
                this.getButton().setVisibility(this.getVisibility());
            }
        }
    }

    protected void updateButtonEnable(ImageButton imageButton) {
        this.getButton().setAlpha(this.isEnabled() ? 255 : 128);
    }

    public ImageButton getButton() {
        return this.mButton;
    }

    public void removeButton() {
        if (this.getButton() != null && this.getButton().getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)this.getButton().getParent();
            viewGroup.removeView((View)this.getButton());
        }
        this.mButton = null;
    }

    public View createButton(Context context) {
        if (this.getButton() != null) {
            this.removeButton();
        }
        this.mButton = new ImageButton(context);
        this.initButton();
        return this.getButton();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof AButtonInfo) {
            AButtonInfo aButtonInfo = (AButtonInfo)object;
            bl = this.getIndex() == aButtonInfo.getIndex() && this.getCommand() == aButtonInfo.getCommand();
        }
        return bl;
    }

    protected boolean onClickInternal(View view) {
        return false;
    }

    public int compareTo(AButtonInfo aButtonInfo) {
        return 0;
    }
}

