/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.dlg.OZLinearLayout;
import oz.viewer.ui.dlg.OZUtilView;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ARefreshManager$1;
import oz.viewer.ui.main.overlay.ARefreshManager$RefreshButtonOnClickListener;
import oz.viewer.ui.main.overlay.OverlayLayout;
import oz.viewer.ui.main.overlay.UserCloseAbleOZOverlayView;

public class ARefreshManager
extends UserCloseAbleOZOverlayView {
    private static final int BTN_ID_START = 1;
    private static final int BTN_ID_STOP = 2;
    private static final int BTN_ID_REFRESH = 3;
    private static final int BTN_ID_HOUR = 4;
    private static final int BTN_ID_MIN = 5;
    private static final int BTN_ID_SEC = 6;
    private static final int BTN_ID_CLOSE = 1000;
    private static final String BTN_IMAGE_START = "resource/toolbar_start@2x.png";
    private static final String BTN_IMAGE_STOP = "resource/toolbar_stop@2x.png";
    private static final String BTN_IMAGE_REFRESH = "resource/toolbar_refresh@2x.png";
    private static final String BTN_IMAGE_CLOSE = "resource/toolbar_close@2x.png";
    private static final String BTN_LABEL_HOUR = "realtime.dlg.hour.label";
    private static final String BTN_LABEL_MIN = "realtime.dlg.min.label";
    private static final String BTN_LABEL_SEC = "realtime.dlg.sec.label";
    private static final int IMAGEBUTTON_ENABLE_ALPHA = 220;
    private static final int IMAGEBUTTON_DISABLE_ALPHA = 100;
    private LinearLayout mView;
    private ARefreshManager$RefreshButtonOnClickListener mOnButtonClickListener;
    private boolean mIsStart;
    private boolean mAllowRefresh;

    public ARefreshManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 6);
        this.setHideVisibility(8);
        this.mOnButtonClickListener = new ARefreshManager$RefreshButtonOnClickListener(this);
        this.setAllowRefresh(true);
        this.initView();
        this.updateView();
    }

    private void initView() {
        this.mView = new LinearLayout(this.getContext());
        this.mView.setOrientation(1);
        this.mView.setGravity(19);
        this.mView.setOnTouchListener((View.OnTouchListener)new ARefreshManager$1(this));
        HorizontalScrollView horizontalScrollView = new HorizontalScrollView(this.getContext());
        horizontalScrollView.addView(this.createContentView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        horizontalScrollView.setBackgroundColor(Color.argb((int)255, (int)217, (int)217, (int)217));
        this.mView.addView((View)horizontalScrollView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        OZUtilView.addComponentSeperaterView(this.getContext(), (ViewGroup)this.mView);
        this.mView.setVisibility(8);
    }

    protected void updateView() {
        View view = this.getView().findViewById(1);
        View view2 = this.getView().findViewById(2);
        View view3 = this.getView().findViewById(3);
        boolean bl = this.isStart();
        boolean bl2 = this.allowRefresh();
        view.setEnabled(!bl);
        AOverlayUtil.setDrawableAlpha(((ImageButton)view).getDrawable(), !bl ? 220 : 100);
        view2.setEnabled(bl);
        AOverlayUtil.setDrawableAlpha(((ImageButton)view2).getDrawable(), bl ? 220 : 100);
        view3.setEnabled(bl2 && !bl);
        AOverlayUtil.setDrawableAlpha(((ImageButton)view3).getDrawable(), bl2 && !bl ? 220 : 100);
    }

    private View createContentView() {
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        linearLayout.setGravity(19);
        linearLayout.setPadding(AOverlayUtil.DpToPx(15), AOverlayUtil.getDP10(), AOverlayUtil.DpToPx(15), AOverlayUtil.getDP10());
        linearLayout.setFocusable(true);
        linearLayout.setFocusableInTouchMode(true);
        this.addImageButton((ViewGroup)linearLayout, 1000, BTN_IMAGE_CLOSE, false, true);
        TextView textView = this.createLabelView("realtime.dlg.period.label");
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = AOverlayUtil.getDP10();
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)textView);
        this.addTimeEditTextWithLabel((ViewGroup)linearLayout, 4, BTN_LABEL_HOUR);
        this.addTimeEditTextWithLabel((ViewGroup)linearLayout, 5, BTN_LABEL_MIN);
        this.addTimeEditTextWithLabel((ViewGroup)linearLayout, 6, BTN_LABEL_SEC);
        this.addImageButton((ViewGroup)linearLayout, 3, BTN_IMAGE_REFRESH, true, false);
        this.addImageButton((ViewGroup)linearLayout, 1, BTN_IMAGE_START, true, false);
        this.addImageButton((ViewGroup)linearLayout, 2, BTN_IMAGE_STOP, true, false);
        return linearLayout;
    }

    private void addImageButton(ViewGroup viewGroup, int n, String string, boolean bl, boolean bl2) {
        ImageButton imageButton = this.createImageButton(n, string);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        if (bl) {
            layoutParams.leftMargin = AOverlayUtil.getDP20();
        }
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        AOverlayUtil.setImageButtonSize(imageButton, 0.8f);
        viewGroup.addView((View)imageButton);
    }

    private void addTimeEditTextWithLabel(ViewGroup viewGroup, int n, String string) {
        OZLinearLayout oZLinearLayout = new OZLinearLayout(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(AOverlayUtil.DpToPx(30), -2);
        layoutParams.leftMargin = AOverlayUtil.getDP10() + AOverlayUtil.getDP5();
        layoutParams.rightMargin = AOverlayUtil.getDP5();
        oZLinearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        EditText editText = this.createTimeEditText();
        editText.setId(n);
        oZLinearLayout.addView((View)editText, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        viewGroup.addView((View)oZLinearLayout);
        viewGroup.addView((View)this.createLabelView(string));
    }

    private ImageButton createImageButton(int n, String string) {
        ImageButton imageButton = AOverlayUtil.createImageButton(this.getContext(), n, string, 220, this.mOnButtonClickListener);
        return imageButton;
    }

    private TextView createLabelView(String string) {
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)OZAndroidResource.getResource(string));
        textView.setTextColor(-16777216);
        return textView;
    }

    private EditText createTimeEditText() {
        EditText editText = new EditText(this.getContext());
        editText.setSingleLine();
        editText.setTextColor(-16777216);
        editText.setInputType(2);
        editText.setText((CharSequence)"0");
        editText.setGravity(17);
        editText.setPadding(AOverlayUtil.getDP5(), AOverlayUtil.getDP5(), AOverlayUtil.getDP5(), AOverlayUtil.getDP5());
        editText.setBackgroundDrawable(null);
        return editText;
    }

    public boolean isStart() {
        return this.mIsStart;
    }

    public void setIsStart(boolean bl) {
        if (this.mIsStart != bl) {
            this.mIsStart = bl;
            this.requestNeedUpdateView();
        }
    }

    public boolean allowRefresh() {
        return this.mAllowRefresh;
    }

    public void setAllowRefresh(boolean bl) {
        if (this.mAllowRefresh != bl) {
            this.mAllowRefresh = bl;
            this.requestNeedUpdateView();
        }
    }

    public void setHour(int n) {
        this.setEditTextInt(4, n);
    }

    public int getHour() {
        return this.getEditTextInt(4);
    }

    public void setMin(int n) {
        this.setEditTextInt(5, n);
    }

    public int getMin() {
        return this.getEditTextInt(5);
    }

    public void setSec(int n) {
        this.setEditTextInt(6, n);
    }

    public int getSec() {
        return this.getEditTextInt(6);
    }

    private void hideKeyboard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(this.getView().findViewById(4).getWindowToken(), 0);
        inputMethodManager.hideSoftInputFromWindow(this.getView().findViewById(5).getWindowToken(), 0);
        inputMethodManager.hideSoftInputFromWindow(this.getView().findViewById(6).getWindowToken(), 0);
    }

    private int getEditTextInt(int n) {
        EditText editText = (EditText)this.getView().findViewById(n);
        String string = editText.getText().toString();
        int n2 = 0;
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private void setEditTextInt(int n, int n2) {
        EditText editText = (EditText)this.getView().findViewById(n);
        editText.setText((CharSequence)String.valueOf(n2));
    }

    public void hide() {
        super.hide();
        this.hideKeyboard();
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(21120);
        frameLayout.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }
}

