package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterDto;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterRelationDto;

/**
 * Created by leej on 2019/06/24.
 */

public class OperationGroupMasterJSON extends AcmsCommonJSON {
    public static final String OperationGroupMasterList = "operationGroupMasterList";
    public static final String OperationGroupMasterId = "operationGroupMasterId";
    public static final String OperationGroupMasterName = "operationGroupMasterName";
    public static final String OperationGroupMasterLevel = "operationGroupMasterLevel";
    public static final String ParentOperationGroupMasterId = "parentOperationGroupMasterId";

    public Integer[] userGroupIds;
    public ArrayList<OperationGroupMasterDto> operationGroupMasterList;

    public OperationGroupMasterJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        operationGroupMasterList = new ArrayList<OperationGroupMasterDto>();
        if (json.has(OperationGroupMasterList)) {
            JSONArray operationGroupMasterJsonList = json.getJSONArray(OperationGroupMasterList);

            for (int i = 0; i < operationGroupMasterJsonList.length(); i++) {
                OperationGroupMasterDto dto = new OperationGroupMasterDto();
                JSONObject operationGroupMasterJson = operationGroupMasterJsonList.getJSONObject(i);
                dto.operationGroupMasterId = getInt(operationGroupMasterJson, OperationGroupMasterId);
                dto.operationGroupMasterName = getString(operationGroupMasterJson, OperationGroupMasterName);
                dto.operationGroupMasterLevel = getInt(operationGroupMasterJson, OperationGroupMasterLevel);
                dto.parentOperationGroupMasterId = getInt(operationGroupMasterJson, ParentOperationGroupMasterId);

                operationGroupMasterList.add(dto);
            }
        }
    }
}
