package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;

public class InviteCollaborationParameters extends HttpParameterObject {
    /**
     * セッションID
     * @since 1.0.0
     */
    private String sid;
    private String cmd;
    private Integer roomId;
    private String roomName;
    private String inviteUserIds;
    private String collaborationType;

    /**
     * {@link InviteCollaborationParameters} のインスタンスを初期化します。
     * @param sid ログインした時のセッションIDです。
     * @param cmd Apiリクエストに必要なコマンド（ABOOK COMM専用）。
     * @param roomId 協業を開始したルームIDです。（ABOOK COMM専用）。
     * @param roomName 協業を開始したルームNAMEです。（ABOOK COMM専用）。
     * @param inviteUserIds 協業に招待されたユーザーIDです。（ABOOK COMM専用）。
     * @param collaborationType 協業タイプです。（ABOOK COMM専用）。
     * @since 1.0.0
     */
    public InviteCollaborationParameters(String sid, String cmd, Integer roomId, String roomName, String inviteUserIds, String collaborationType) {
        this.sid = sid;
        this.cmd = cmd;
        this.roomId = roomId;
        this.roomName = roomName;
        this.inviteUserIds = inviteUserIds;
        this.collaborationType = collaborationType;
    }

    /**
     * セッションIDを返します。
     * @return ログインした時のセッションIDです。
     * @since 1.0.0
     */
    public String getSid() {
        return sid;
    }

    /**
     * コマンドを返します。
     * @return Apiリクエストに必要なコマンドです。
     * @since 1.0.0
     */
    public String getCmd() {
        return cmd;
    }

    /**
     * RoomIdを返します。
     * @return 協業を開始したルームIDです。
     * @since 1.0.0
     */
    public Integer getRoomId() {
        return roomId;
    }

    /**
     * RoomNameを返します。
     * @return 協業を開始したルームNAMEです。
     * @since 1.0.0
     */
    public String getRoomName() {
        return roomName;
    }

    /**
     * InviteUserIdsを返します。
     * @return 協業に招待されたユーザーIDです。
     * @since 1.0.0
     */
    public String getInviteUserIds() {
        return inviteUserIds;
    }

    /**
     * collaborationTypeを返します。
     * @return 協業タイプです。
     * @since 1.0.0
     */
    public String getCollaborationType() {
        return collaborationType;
    }

}
