package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.util.StringUtil;

/**
 * ユーザ認証（初回）用のパラメータです。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class NewAppStoreLoginParameters extends AbstractAcmsLoginParameters {
	/**
	 * 契約事業者のアカウント文字列です。
	 * @since 1.0.0
	 */
	private String urlPath;
	
	/**
	 * {@link NewAppStoreLoginParameters} クラスのインスタンスを初期化します。
	 * @param urlPath 契約事業者のアカウント文字列です。
	 * @param loginId ユーザのログインIDです。半角英数字と'_'、'-'のみ使えます。
	 * @param memberPassword ユーザのパスワードです。半角英数字と'_'、'-'のみ使えます。
	 * @param appId アプリケーションIDです。
	 * @param appVersion アプリケーションの現在バージョンです。
	 * @param deviceToken デバイストークンです。
	 * @param deviceTypeId 端末タイプです。
	 * @param ma 端末のMACアドレスです。 
	 * @throws IllegalArgumentException 引数のどれかが半角英数字と'_'、'-'ではありません。
	 * @since 1.0.0
	 */
	public NewAppStoreLoginParameters(String urlPath, String loginId, String memberPassword, int appId, String appVersion
			, int deviceTypeId, String deviceToken, String ma) throws IllegalArgumentException {
		super(loginId, memberPassword, appId, appVersion, deviceTypeId, deviceToken, ma);
		
		if (StringUtil.isNullOrWhiteSpace(urlPath)) {
			throw new IllegalArgumentException("argument urlPath not allowed null or white space.");
		}

		this.urlPath = urlPath;
	}
	/**
	 * 契約事業者のアカウント文字列を取得します。
	 * @return 契約事業者のアカウント文字列です。
	 * @since 1.0.0
	 */
	public String getUrlPath() {
		return urlPath;
	}
}
