package jp.agentec.abook.abv.bl.acms.type;

/**
 * ユーザのログイン状態を示します。
 * @author Taejin Hong
 * @version　1.0.0 
 */
public enum LoginStatus {
	/**
	 * ログインしています。
	 * @since 1.0.0
	 */
	LoggedIn(1),
	/**
	 * ログアウトしています。
	 * @since 1.0.0
	 */
	LoggedOut(0),
	/**
	 * ユーザのアカウントはロックされています。
	 * @since 1.0.0
	 */
	Locked(-1),
	/**
	 * 一定期間経過後アプリロックされています
	 * @since 4.0.0
	 */
	LimitLogin(2),
	/**
	 * 一定期間経過後強制ログアウトされています
	 * @since 4.0.0
	 */
	ForceLoggedOut(3);
	
	private final int index;
	
	LoginStatus(int index) {
		this.index = index;
	}
	
	public int statusCode() {
		return index;
	}
}
