package jp.agentec.abook.abv.bl.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CommonExecutor {
	private static ExecutorService cachedExecutor = Executors.newCachedThreadPool();
	
	public static void execute(Runnable task) {
		cachedExecutor.execute(task);
	}
	
	public static <T> Future<T> submit(Callable<T> task) {
		return cachedExecutor.submit(task);
	}
	
	public static void shutdown() {
		cachedExecutor.shutdownNow();
	}

}
