package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.CollaborationDto;

public class CollaborationDao extends AbstractCommunicationDao {

	/**
	 * {@link CollaborationDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ CollaborationDao() {
	}

	@Override
	protected CollaborationDto convert(Cursor cursor) {
		CollaborationDto dto = new CollaborationDto();

		int column = cursor.getColumnIndex("collaboration_id");
		if (column != -1) {
			dto.collaborationId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("chat_message_id");
		if (column != -1) {
			dto.chatMessageId = cursor.getInt(column);
		}
		return dto;
	}

	public List<CollaborationDto> getCollaboration(int collaborationId) {
		List<CollaborationDto> list = rawQueryGetDtoList("select * from t_collaboration where collaboration_id = ?", new String[]{""+ collaborationId}, CollaborationDto.class);
		return list;
	}

	public void insertCollaboration(CollaborationDto dto) {
		insert("insert into t_collaboration (collaboration_id, chat_message_id) values (?,?)", dto.getInsertValues());
	}

	public void deleteCollaboration() {
		try {
			beginTransaction();
			delete("t_collaboration", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteCollaboration failed.", e);
			throw new RuntimeException(e);
		}
	}

}
