package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.MarkingSettingDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class MarkingSettingDao extends AbstractDao {

	/*package*/ MarkingSettingDao() {
	}

	@Override
	protected MarkingSettingDto convert(Cursor cursor) {
		MarkingSettingDto dto = new MarkingSettingDto();

		int column = cursor.getColumnIndex("marking_setting_id");
		if (column != -1) {
			dto.markingSettingId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("color");
		if (column != -1) {
			dto.color = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("width");
		if (column != -1) {
			dto.width = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("insert_date");
		if (column != -1) {
			dto.insertDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}
		column = cursor.getColumnIndex("update_date");
		if (column != -1) {
			dto.updateDate = DateTimeUtil.toDate(cursor.getString(column), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
		}

		return dto;
	}


	public MarkingSettingDto getMarkingSettingDto(int markingSettingId) {
		return rawQueryGetDto("select * from t_marking_setting where marking_setting_id=?", new String[]{""+ markingSettingId}, MarkingSettingDto.class);
	}

	public List<MarkingSettingDto> getMarkingSettingList() {
		return rawQueryGetDtoList("select * from t_marking_setting", null, MarkingSettingDto.class);
	}

	public boolean updateMarkingSetting(MarkingSettingDto dto) {
		long count = update("update t_marking_setting set color=?, width=?, update_date=? where marking_setting_id=?", dto.getUpdateValues());
		return (count > 0);
	}

}
