package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.TaskWorkerGroupDto;
import jp.agentec.abook.abv.bl.dto.WorkerGroupDto;

/**
 * Created by leej on 2019/03/19.
 */

public class TaskWorkerGroupDao extends AbstractDao {
    private static final String TAG = "TaskReportDao";

    /*package*/ TaskWorkerGroupDao() {
    }

    @Override
    protected TaskWorkerGroupDto convert(Cursor cursor) {
        TaskWorkerGroupDto dto = new TaskWorkerGroupDto();

        int column = cursor.getColumnIndex("task_report_level");
        if (column != -1) {
            dto.taskReportLevel = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("operation_id");
        if (column != -1) {
            dto.operationId = cursor.getLong(column);
        }
        column = cursor.getColumnIndex("group_id");
        if (column != -1) {
            dto.groupId = cursor.getInt(column);
        }

        column = cursor.getColumnIndex("group_name");
        if (column != -1) {
            dto.groupName = cursor.getString(column);
        }
        return dto;
    }


    public void insert(TaskWorkerGroupDto dto) {
        insert("insert into r_task_worker_group "
                        + "(task_report_level, "
                        + "operation_id, "
                        + "group_id ) "
                        + "values "
                        + "(?,?,?)",
                dto.getInsertValues());
    }

    /**
     * 作業に紐づいた作業担当グループを削除
     * @param operationId
     */
    public void deleteByOperationId(Long operationId) {
        delete("r_task_worker_group", "operation_id=?", new String[]{""+ operationId});
    }

    /**
     * 作業IDに紐づいた作業担当グループを取得
     * inner joing m_worker_group(作業名取得)
     * @param operationId
     * @return
     */
    public List<TaskWorkerGroupDto> getTaskWorkerGroupByOperationId(Long operationId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT rtwg.task_report_level, rtwg.operation_id, rtwg.group_id, mwg.group_name ");
        sql.append(" FROM r_task_worker_group AS rtwg ");
        sql.append(" INNER JOIN m_worker_group AS mwg ");
        sql.append(" ON rtwg.group_id = mwg.group_id ");
        sql.append(" WHERE rtwg.operation_id = ? ");
        sql.append(" ORDER BY rtwg.task_report_level ASC ");
        Logger.v(TAG, "sql=%s", sql);
        return rawQueryGetDtoList(sql.toString(), new String[]{""+ operationId}, TaskWorkerGroupDto.class);
    }
}
