package jp.agentec.abook.abv.bl.dto;

import jp.agentec.adf.util.FileUtil;

/**
 * コンテンツの詳細情報を格納します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class ContentPageDto extends AbstractDto {
	public long contentId;
	public int pageNum;
	public String pageText;
	public String pageThumbnailName;
	
	/**
	 * pagePath + pageThumbnailName
	 * @since 1.0.0
	 */
	public String pageThumbnailPath;
	public String pagePath;
	
	public String searchResult; // TODO: 検索結果はこのオブジェクトを使うべきではない
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{contentId, pageNum, pageText, pageThumbnailName};
	}

	public String getPageThumbnailPath() {
		return pagePath + pageThumbnailName;
	}
	
	public void setPagePath(String pagePath) {
		this.pagePath = FileUtil.addPathSeparator(pagePath);
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{""+ contentId, ""+ pageNum};
	}
}
