package jp.agentec.abook.abv.bl.dto;

import java.util.Date;


/**
 * MarkingSetting情報を格納します。
 * 
 * @author Tauchi
 * @version　1.0.0
 */
public class MarkingSettingDto extends AbstractDto {
	public int markingSettingId;
	public int color;
	public int width;
	public Date insertDate;
	public Date updateDate;
	
	@Override
	public Object[] getInsertValues() {
		return new Object[]{markingSettingId, color, width, insertDate, updateDate};
	}

	@Override
	public Object[] getUpdateValues() {
		return new Object[]{color, width, updateDate, markingSettingId};
	}
	
	@Override
	public String[] getKeyValues() {
		return new String[] {""+ markingSettingId};
	}

	public enum ID{
		PEN(0),
		MARKER(1),
		ERASER(2);
		
		private int id;
		
		ID(int id) {
			this.id = id;
		}
		
		public int getIntValue() {
			return id;
		}
	}
}
