package jp.agentec.abook.abv.bl.logic;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.parameters.GetEnqueteReplyParameters;
import jp.agentec.abook.abv.bl.acms.client.parameters.EnqueteReplyParameters;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.EnqueteDao;
import jp.agentec.abook.abv.bl.dto.EnqueteDto;

public class EnqueteLogic extends AbstractLogic {
	private EnqueteDao dao = AbstractDao.getDao(EnqueteDao.class);
	
	/**
	 * {@link EnqueteLogic} クラスのインスタンスを初期化します。
	 * @see AbstractLogic
	 * @since 1.0.0
	 */
	/*package*/ EnqueteLogic() {
	}
	
	public List<EnqueteDto> getEnquete(long content_id, long ab_object_id) {
		return dao.getEnqueteList(content_id, ab_object_id);
	}

	public List<EnqueteDto> getReplyEnquete() {
		return dao.getReplyEnquete();
	}
	
	public void insertEnquete(EnqueteDto dto) {
		dao.insertEnquete(dto);
	}
	
	public boolean updateEnquete(EnqueteDto dto) {
		return dao.updateEnquete(dto);
	}

	public boolean getCheckEnqueteId(long content_id, long ab_enquete_id) {
		return dao.isCheckEnqueteId(content_id, ab_enquete_id);
	}
	
	public boolean getLimitEnquete(long content_id, long ab_object_id) {
		List<EnqueteDto> list = dao.getEnqueteList(content_id, ab_object_id);
		return list.size()>0;
	}
	
	public boolean enqueteReply(long contentId, long abObjectId, Date replyDateStr, String param) throws AcmsException, NetworkDisconnectedException {
		String result;
		AcmsClient acms = AcmsClient.getInstance(cache.getUrlPath(), networkAdapter);
		Timestamp replyDateStr1 = new Timestamp(replyDateStr.getTime());
		GetEnqueteReplyParameters getParam = new GetEnqueteReplyParameters(cache.getMemberInfo().sid, contentId, abObjectId, replyDateStr1, 3);
		EnqueteReplyParameters postParam = new EnqueteReplyParameters(param);
		result = acms.enqueteReply(postParam, getParam);
		return result.equals("success");
	}
	
}
