package jp.agentec.adf.net.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HttpHeaderProperties {
	private Map<PropertyKey, String> properties = null;
	
	public enum PropertyKey {
		UserAgent("User-Agent"),
		ContentLength("Content-Length"),
		IfModifiedSince("If-Modified-Since"),
		Range("Range"),
		AcceptCharset("Accept-Charset"),
		ContentType("Content-Type"),
		ContentDisposition("Content-Disposition"),
		ContentTransferEncoding("Content-Transfer-Encoding"),
		IfNoneMatch("If-None-Match");
		
		private final String key;
		
		PropertyKey(String key) {
			this.key = key;
		}
		
		public String key() {
			return key;
		}
	}
	
	public HttpHeaderProperties() {
		properties = new HashMap<PropertyKey, String>();
	}
	
	public void addProperty(PropertyKey key, String value) {
		properties.put(key, value);
	}
	
	public Set<PropertyKey> keySet() {
		return properties.keySet();
	}
	
	public String get(PropertyKey key) {
		return properties.get(key);
	}
	
	public int size() {
		return properties.size();
	}
	
	public boolean containsKey(PropertyKey key) {
		return properties.containsKey(key);
	}
	
	public boolean containsValue(String value) {
		return properties.containsValue(value);
	}
}
