package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.log.LogLevel;
import jp.agentec.abook.abv.bl.data.DBConnector;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class EnqueteDaoTest extends TestCase {

	private EnqueteDao dao = AbstractDao.getDao(EnqueteDao.class);

	public EnqueteDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		ABVEnvironment.getInstance().setLogLevel(LogLevel.verbose);

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("EnqueteDaoTest");
		suite.addTest(new EnqueteDaoTest("deleteUnsendEnquete"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void deleteUnsendEnquete() {
		dao.deleteUnsendEnquete(null);
		dao.deleteUnsendEnquete("");
		dao.deleteUnsendEnquete("24");
		dao.deleteUnsendEnquete("25,26,27");
	}

}
