package jp.agentec.abook.abv.bl.download;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.nw.PCNetworkAdapter;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.adf.net.http.HttpDownloadSimpleNotification;
import jp.agentec.adf.net.http.HttpRequestSender;

import org.junit.Before;
import org.junit.Test;

/**
 * 
 * 注： test.dbは実環境で一度ログインしたものを使用して、実際のsidをセットすること
 * categoryLogic.initializeCategories();カテゴリ設定で失敗するのでテストする場合はその部分をコメントアウトして実行
 * 
 */
public class ContentRefresherTest {
	private String sid = "4475bbc5a74a1029b35ab54f06727647";
	private ContentRefresher contentRefresher = ContentRefresher.getInstance();
	
	@Before
	public void setup() {
		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
		
		ABVEnvironment.getInstance().networkAdapter = new PCNetworkAdapter();
		ABVDataCache.getInstance().getMemberInfo().sid = sid;
		ABVEnvironment.getInstance().acmsAddress = "https://web5.abook.bz/acms";
		ABVEnvironment.getInstance().downloadServerAddress = "https://web5.abook.bz/acms";
		HttpRequestSender.testUserAgent = "Android";
		ABVEnvironment.getInstance().rootDirectory = "/var/android";
		ABVEnvironment.getInstance().cacheDirectory= "/var/android/cache";
	}
	
	@Test
	public void test() throws NetworkDisconnectedException, Exception {
		contentRefresher.refreshContentList(new ContentDownloadListener() {
			
			@Override
			public void onRefreshedContent(boolean result, long contentId, Exception e) {
				System.out.println("onRefreshedContent");
			}
			
			@Override
			public void onDownloadingContentZip(ContentZipDownloadNotification notification) {
			}
			@Override
			public void onDownloadedContentDetail(HttpDownloadSimpleNotification notification) {
			}
			
			@Override
			public void onAuthenticationFailed() {
				System.out.println("onAuthenticationFailed");
			}
		});
		
		
		Thread.sleep(10000);
	}

}
