package jp.agentec.abook.abv.cl.util;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;

public interface BleManagerUtilListener {
    void onGetDeviceInfo(String strTemperature); // ディバイスから渡す情報
    void onGetDeviceInfoFailed(int status); // ディバイスと接続失敗時の情報渡す。
    void onConnectionState(int status); // ディバイスと接続された時情報渡す。
    void onDisConnectionState(); // ディバイスと切断時
    void onConnectionError(int status); // ディバイス接続エラー
    // アルコールチェッカーで追加
    void onServicesDiscovered(BluetoothGatt gatt, int status);
    void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic);
    void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status);
}
