package jp.agentec.abook.abv.ui.common.activity;

import android.content.DialogInterface;
import android.os.Bundle;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.PushMessageKey;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.ChatWebViewActivity;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.StringUtil;

public class ShowPushMessageDailogActivity extends ABVUIActivity {
    private static final String TAG = "ShowPushMessageDailogActivity";

    OperationLogic mOperationLogic = AbstractLogic.getLogic(OperationLogic.class);
    boolean isMeetingRoomConnected = false;
    boolean isCollabration = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String data = getIntent().getExtras() != null ? getIntent().getExtras().getString(PushMessageKey.data) : null;
        if (StringUtil.isNullOrEmpty(data)) {
            final long operationId = StringUtil.isNullOrEmpty(getIntent().getExtras().getString(PushMessageKey.operationId)) ? 0 : Long.parseLong(getIntent().getExtras().getString(PushMessageKey.operationId));

            if (operationId > 0) {
                Logger.d(TAG, "operationId : " + operationId);
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this, getRString(R.string.app_name), getIntent().getExtras().getString(PushMessageKey.message));

                // リソースパターンの適用
                alertDialog.setPositiveButton(PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.work_report,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                        new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (contentRefresher.isRefreshing()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_refreshing,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else if(ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_meeting_room,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else {
                            OperationListActivity operationListActivity = ActivityHandlingHelper.getInstance().getPreviousOperationListActivity();
                            if (operationListActivity != null && operationListActivity.isShowingBatchSync()) {
                                Logger.d(TAG, "is showing Batch Sync");
                                // 一括同期中は移動しない
                                ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, getString(R.string.msg_batch_sync_move_operation_view));
                            } else {
                                OperationDto operationDto = mOperationLogic.getOperation(operationId);
                                if (operationDto == null) {
                                    Logger.d(TAG, "operationDto is null");
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                            R.string.msg_routineTask_report_disable_no_operation,
                                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                } else if (operationDto.needSyncFlg) {
                                    Logger.d(TAG, "needSyncFlg is true");
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                            R.string.msg_routineTask_report_disable_not_updated,
                                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                } else {
                                    if (operationListActivity != null) {
                                        Logger.d(TAG, "startTaskDirectionOrReportView");
                                        operationListActivity.startTaskDirectionOrReportView(operationDto);
                                    } else {
                                        Logger.d(TAG, "operationListActivity is null");
                                        // リソースパターンの適用
                                        ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.msg_routineTask_report_disable_not_list,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                    }
                                }
                            }
                        }
                        dialog.dismiss();
                    }
                });

                alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.dismiss();
                    }
                });

                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        finish();
                    }
                });

                alertDialog.show();
            } else {
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this,
                        getRString(R.string.app_name),
                        getIntent().getExtras().getString(PushMessageKey.message));
                Bundle extras = getIntent().getExtras();
                Long roomId = extras.getLong(AppDefType.ChatPushMessageKey.roomId, 0);
                if (roomId == 0) {
                    alertDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            setResult(ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.CANCEL, getIntent());
                            dialog.dismiss();
                        }
                    });
                } else {
                    alertDialog.setPositiveButton(R.string.move, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            isMeetingRoomConnected = MeetingManager.getInstance().isConnected();
                            isCollabration = MeetingManager.getInstance().isCollaboration();
                            Bundle extras = getIntent().getExtras();
                            if (isMeetingRoomConnected || isCollabration) {
                                showCannotMoveChatRoomDialog();
                            } else {
                                if (extras != null) {
                                    boolean isNewVersion = extras.getBoolean(AppDefType.ChatPushMessageKey.needsDisplayOperationOrOperationRelatedContentScreen);
                                    if (isNewVersion) {
                                        setResult(ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.OK, getIntent());
                                    } else {
                                        moveChatRoom(extras);
                                    }
                                }
                            }
                            dialog.dismiss();
                        }
                    });
                    alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            setResult(ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.CANCEL, getIntent());
                            dialog.dismiss();
                        }
                    });
                }
                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        finish();
                    }
                });
                alertDialog.show();
            }
        }
    }

    /**
     * チャットルームへ遷移するための処理
     * @param extras
     */
    private void moveChatRoom(Bundle extras) {
        Long roomId = extras.getLong(AppDefType.ChatPushMessageKey.roomId, 0);
        String roomName = extras.getString(AppDefType.ChatPushMessageKey.roomName);
        String collaborationType = extras.getString(AppDefType.ChatPushMessageKey.collaborationType);
        String roomType = extras.getString(AppDefType.ChatPushMessageKey.roomType);
        if (roomId > 0 && !StringUtil.isNullOrEmpty(roomName)) {
            ChatWebViewActivity chatWebViewActivity= activityHandlingHelper.getChatWebViewActivity();
            if (chatWebViewActivity != null) {
                chatWebViewActivity.reloadRoomViewCollaboration(roomId, roomName, collaborationType);
            } else {
                if (StringUtil.isNullOrEmpty(collaborationType)) {
                    ActivityHandlingHelper.getInstance().startChatWebViewActivity(roomId, roomName, ChatWebViewActivity.class.getName(),"");
                } else {
                    ActivityHandlingHelper.getInstance().startChatWebViewActivityWithCollaboration(roomId,
                            roomName,
                            collaborationType,
                            roomType,
                            ChatWebViewActivity.class.getName(),
                            "");
                }
            }
        }
    }

    /**
     * 遠隔支援中（会議室接続中）はチャットルームにはいけない。
     */
    private void showCannotMoveChatRoomDialog() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                String dialogMessage = null;
                if (isCollabration) {
                    dialogMessage = getRString(R.string.chat_open_fail_collaborattion_connected);
                } else if (isMeetingRoomConnected) {
                    dialogMessage = getRString(R.string.chat_open_fail_meeting_connected);
                }
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this,
                        getRString(R.string.app_name),
                        dialogMessage);
                alertDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        setResult(ABookCommConstants.PUSH_MESSAGE_DLG_RESULT.CANCEL, getIntent());
                        finish();
                    }
                });
                alertDialog.show();
            }
        });
    }
}
