package jp.agentec.abook.abv.ui.common.helper;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVActivity;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import android.content.DialogInterface;

public class NavigationExceptionForReader extends NavigationContentDownloadForReader {

	public NavigationExceptionForReader(NavigationForReaderInterface contentReaderInterface, ABVActivity activity) {
		super(contentReaderInterface, activity);
	}
	
	@Override
	public void moveToNextDisposal() {
		mContentReaderInterface.onFinishPushActivity();
	}

	@Override
	public void showMessageDialog(String title, String msg) {
		
		ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(mActivity, title, msg);
		alertDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				moveToNextDisposal();
			}
		});
		alertDialog.show();
	}
}
