package jp.agentec.abook.abv.ui.common.view;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;

public class ABVPopupListWindow extends PopupWindow {

	public TextView titleView;
	
	private View mRoot;
	
	private Context mContext;
	
	public ABVPopupListWindow(Context context, int resId) {
		super(context);
		setBackgroundDrawable(context.getResources().getDrawable(R.drawable.bg_dropshadow));
		setFocusable(true);
		setOutsideTouchable(true);
		setWidth(ViewGroup.LayoutParams.WRAP_CONTENT); // default width
		setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
		
		mRoot = ((Activity)context).getLayoutInflater().inflate(resId, null);
		mContext = context;
		setContentView(mRoot);
	}
	
	public ABVPopupListWindow(Context context) {
		this(context, R.layout.popup_nohead_list);
	}
	
	public ABVPopupListWindow(Activity activity, String title) {
		this(activity);
		setTitle(title);
	}
	
	public View findViewById(int id) {
		return mRoot.findViewById(id);
	}
	
	public void setTitle(String title) {
		titleView = (TextView) mRoot.findViewById(R.id.popup_title);
		titleView.setText(title);
	}
	
	public View getToolbarView() {
		return mRoot.findViewById(R.id.toolbar);
	}
	
	public void noTitleBar() {
		View v = mRoot.findViewById(R.id.toolbar);
		if (v != null) {
            v.setVisibility(View.GONE);
        }
	}
	
	public void setRepresentNames(String[] names) {
		ArrayAdapter<String> adapter = new ArrayAdapter<>(mContext, R.layout.item_popup_list_simple, names);
		setListViewAdapter(adapter);
	}
	
	public void setRepresentNames(List<String> names) {
		ArrayAdapter<String> adapter = new ArrayAdapter<>(mContext, R.layout.item_popup_list_simple, names);
		setListViewAdapter(adapter);
	}
	
	public void setListViewAdapter(ListAdapter adapter) {
		ListView listView = getListView();
		listView.setAdapter(adapter);
		listView.setItemsCanFocus(true);
	}
	
	public void setHeaderView(View headerView) {
		LinearLayout linearLayout = (LinearLayout) mRoot.findViewById(R.id.popup_header);
		linearLayout.addView(headerView);
		linearLayout.setVisibility(View.VISIBLE);
	}
	
	public void setFooterView(View footerView) {
		LinearLayout linearLayout = (LinearLayout) mRoot.findViewById(R.id.popup_footer);
		linearLayout.addView(footerView);
		linearLayout.setVisibility(View.VISIBLE);
	}
	
	public void setListEmptyText(String text) {
		TextView textView = (TextView) mRoot.findViewById(R.id.empty_list_item);
		getListView().setEmptyView(textView);
		textView.setText(text);
	}
	
	public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
		getListView().setOnItemClickListener(listener);
	}
	
	public void setLeftItemOnClickListener(String itemName, View.OnClickListener l) {
		Button itemButton = (Button) mRoot.findViewById(R.id.popup_title_left);
		itemButton.setVisibility(View.VISIBLE);
		itemButton.setText(itemName);
		itemButton.setOnClickListener(l);
	}
	
	public void setRightItemOnClickListener(String itemName, View.OnClickListener l) {
		Button itemButton = (Button) mRoot.findViewById(R.id.popup_right_title);
		itemButton.setText(itemName);
		itemButton.setVisibility(View.VISIBLE);
		itemButton.setOnClickListener(l);
	}
	
	public ListView getListView() {
		return (ListView) mRoot.findViewById(R.id.popup_list_menu);
	}
	
	
//	@Override
//	public void showAsDropDown(View anchor) {
//		setPressedAnchor(anchor);
//		setDismissListiner(anchor);
//		super.showAsDropDown(anchor);
//	}
	
	@Override
	public void showAsDropDown(View anchor, int xoff, int yoff) {
		setPressedAnchor(anchor);
		setDismissListiner(anchor);
		super.showAsDropDown(anchor, xoff, yoff);
	}
	
	private void setPressedAnchor(final View anchor) {
		anchor.postDelayed(new Runnable() {
			@Override
			public void run() {
				anchor.setPressed(true);
			}
		}, 200);
	}

	private void setDismissListiner(final View anchor) {
		setOnDismissListener(new OnDismissListener() {
			@Override
			public void onDismiss() {
				if ((anchor instanceof Button || anchor instanceof ImageButton)) {
					anchor.setPressed(false);
				}
			}
		});		
	}
	
	public static int getWidestView(Context context, Adapter adapter) {
	    int maxWidth = 0;
	    View view = null;
	    FrameLayout fakeParent = new FrameLayout(context);
	    for (int i = 0, count = adapter.getCount(); i < count; i++) {
	        view = adapter.getView(i, view, fakeParent);
	        view.measure(View.MeasureSpec.UNSPECIFIED, View.MeasureSpec.UNSPECIFIED);
	        int width = view.getMeasuredWidth();
	        if (width > maxWidth) {
	            maxWidth = width;
	        }
	    }
	    return maxWidth;
	}
	
}
