package jp.agentec.abook.abv.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by kim, changgyun on 2018/11/15.
 */

public class OperationSelectAdapter extends BaseAdapter {
    private static final String TAG = "OperationSelectAdapter";
    private Context mContext;
    private LayoutInflater mInflater;
    private List<OperationDto> mListItem = new ArrayList<>();

    public OperationSelectAdapter(Context context, List<OperationDto> listItem) {
        mContext = context;
        mListItem = listItem;
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }
    public List<OperationDto> getData() {
        return mListItem;
    }
    @Override
    public int getCount() {
        return mListItem.size();
    }

    @Override
    public OperationDto getItem(int position) {
        return mListItem.get(position);
    }

    @Override
    public long getItemId(int position) {
        return mListItem.get(position).operationId;
    }

    public void setItem(List<OperationDto> listItem) {
        mListItem= listItem;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder holder;
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_operation_select, parent, false);
            holder = new OperationSelectAdapter.ViewHolder();
            holder.tvOperationName = (TextView) convertView.findViewById(R.id.operation_name);
            holder.ivNaviNext = (ImageView) convertView.findViewById(R.id.nextLevel);

            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        final OperationDto operationDto = getItem(position);

        if (operationDto != null) {
            holder.tvOperationName.setText(operationDto.operationName);
        }

        return convertView;
    }

    private static class ViewHolder {
        TextView tvOperationName;
        ImageView ivNaviNext;
    }

}
