/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.encoder;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.WriterException;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.common.CharacterSetECI;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonEncoder;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;
import oz.util.barcode.qrcode.decoder.Mode;
import oz.util.barcode.qrcode.decoder.Version;
import oz.util.barcode.qrcode.decoder.Version$ECBlocks;
import oz.util.barcode.qrcode.encoder.BlockPair;
import oz.util.barcode.qrcode.encoder.ByteMatrix;
import oz.util.barcode.qrcode.encoder.MaskUtil;
import oz.util.barcode.qrcode.encoder.MatrixUtil;
import oz.util.barcode.qrcode.encoder.QRCode;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE;
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    static {
        int[] nArray = new int[96];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = -1;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 36;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = 37;
        nArray[37] = 38;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = 39;
        nArray[43] = 40;
        nArray[44] = -1;
        nArray[45] = 41;
        nArray[46] = 42;
        nArray[47] = 43;
        nArray[49] = 1;
        nArray[50] = 2;
        nArray[51] = 3;
        nArray[52] = 4;
        nArray[53] = 5;
        nArray[54] = 6;
        nArray[55] = 7;
        nArray[56] = 8;
        nArray[57] = 9;
        nArray[58] = 44;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = 10;
        nArray[66] = 11;
        nArray[67] = 12;
        nArray[68] = 13;
        nArray[69] = 14;
        nArray[70] = 15;
        nArray[71] = 16;
        nArray[72] = 17;
        nArray[73] = 18;
        nArray[74] = 19;
        nArray[75] = 20;
        nArray[76] = 21;
        nArray[77] = 22;
        nArray[78] = 23;
        nArray[79] = 24;
        nArray[80] = 25;
        nArray[81] = 26;
        nArray[82] = 27;
        nArray[83] = 28;
        nArray[84] = 29;
        nArray[85] = 30;
        nArray[86] = 31;
        nArray[87] = 32;
        nArray[88] = 33;
        nArray[89] = 34;
        nArray[90] = 35;
        nArray[91] = -1;
        nArray[92] = -1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[95] = -1;
        ALPHANUMERIC_TABLE = nArray;
    }

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel) {
        return Encoder.encode(string, errorCorrectionLevel, null);
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel, Map map) {
        Object object;
        String string2;
        String string3 = string2 = map == null ? null : (String)map.get((Object)EncodeHintType.CHARACTER_SET);
        if (string2 == null) {
            string2 = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(string, string2);
        BitArray bitArray = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(string2) && (object = CharacterSetECI.getCharacterSetECIByName(string2)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object), bitArray);
        }
        Encoder.appendModeInfo(mode, bitArray);
        object = new BitArray();
        Encoder.appendBytes(string, mode, (BitArray)object, string2);
        int n = bitArray.getSize() + mode.getCharacterCountBits(Version.getVersionForNumber(1)) + ((BitArray)object).getSize();
        Version version = Encoder.chooseVersion(n, errorCorrectionLevel);
        int n2 = bitArray.getSize() + mode.getCharacterCountBits(version) + ((BitArray)object).getSize();
        Version version2 = Encoder.chooseVersion(n2, errorCorrectionLevel);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBitArray(bitArray);
        int n3 = mode == Mode.BYTE ? ((BitArray)object).getSizeInBytes() : string.length();
        Encoder.appendLengthInfo(n3, version2, mode, bitArray2);
        bitArray2.appendBitArray((BitArray)object);
        Version$ECBlocks version$ECBlocks = version2.getECBlocksForLevel(errorCorrectionLevel);
        int n4 = version2.getTotalCodewords() - version$ECBlocks.getTotalECCodewords();
        Encoder.terminateBits(n4, bitArray2);
        BitArray bitArray3 = Encoder.interleaveWithECBytes(bitArray2, version2.getTotalCodewords(), n4, version$ECBlocks.getNumBlocks());
        QRCode qRCode = new QRCode();
        qRCode.setECLevel(errorCorrectionLevel);
        qRCode.setMode(mode);
        qRCode.setVersion(version2);
        int n5 = version2.getDimensionForVersion();
        ByteMatrix byteMatrix = new ByteMatrix(n5, n5);
        int n6 = Encoder.chooseMaskPattern(bitArray3, errorCorrectionLevel, version2, byteMatrix);
        qRCode.setMaskPattern(n6);
        MatrixUtil.buildMatrix(bitArray3, errorCorrectionLevel, version2, n6, byteMatrix);
        qRCode.setMatrix(byteMatrix);
        return qRCode;
    }

    static int getAlphanumericCode(int n) {
        if (n < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[n];
        }
        return -1;
    }

    public static Mode chooseMode(String string) {
        return Encoder.chooseMode(string, null);
    }

    private static Mode chooseMode(String string, String string2) {
        if ("Shift_JIS".equals(string2)) {
            return Encoder.isOnlyDoubleByteKanji(string) ? Mode.KANJI : Mode.BYTE;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 >= '0' && c2 <= '9') {
                bl = true;
            } else if (Encoder.getAlphanumericCode(c2) != -1) {
                bl2 = true;
            } else {
                return Mode.BYTE;
            }
            ++n;
        }
        if (bl2) {
            return Mode.ALPHANUMERIC;
        }
        if (bl) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            if (!(n3 >= 129 && n3 <= 159 || n3 >= 224 && n3 <= 235)) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        while (n3 < 8) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, n3, byteMatrix);
            int n4 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n4 < n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    private static Version chooseVersion(int n, ErrorCorrectionLevel errorCorrectionLevel) {
        int n2 = 1;
        while (n2 <= 40) {
            int n3;
            Version$ECBlocks version$ECBlocks;
            int n4;
            Version version = Version.getVersionForNumber(n2);
            int n5 = version.getTotalCodewords();
            int n6 = n5 - (n4 = (version$ECBlocks = version.getECBlocksForLevel(errorCorrectionLevel)).getTotalECCodewords());
            if (n6 >= (n3 = (n + 7) / 8)) {
                return version;
            }
            ++n2;
        }
        throw new WriterException("Data too big");
    }

    static void terminateBits(int n, BitArray bitArray) {
        int n2;
        int n3 = n << 3;
        if (bitArray.getSize() > n3) {
            throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n3);
        }
        int n4 = 0;
        while (n4 < 4 && bitArray.getSize() < n3) {
            bitArray.appendBit(false);
            ++n4;
        }
        n4 = bitArray.getSize() & 7;
        if (n4 > 0) {
            n2 = n4;
            while (n2 < 8) {
                bitArray.appendBit(false);
                ++n2;
            }
        }
        n2 = n - bitArray.getSizeInBytes();
        int n5 = 0;
        while (n5 < n2) {
            bitArray.appendBits((n5 & 1) == 0 ? 236 : 17, 8);
            ++n5;
        }
        if (bitArray.getSize() != n3) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        if (n4 >= n3) {
            throw new WriterException("Block ID too large");
        }
        int n5 = n % n3;
        int n6 = n3 - n5;
        int n7 = n / n3;
        int n8 = n2 / n3;
        int n9 = n7 - n8;
        int n10 = n7 + 1;
        int n11 = n8 + 1;
        int n12 = n10 - n11;
        if (n9 != n12) {
            throw new WriterException("EC bytes mismatch");
        }
        if (n3 != n6 + n5) {
            throw new WriterException("RS blocks mismatch");
        }
        if (n != (n8 + n9) * n6 + (n11 + n12) * n5) {
            throw new WriterException("Total bytes mismatch");
        }
        if (n4 < n6) {
            nArray[0] = n8;
            nArray2[0] = n9;
        } else {
            nArray[0] = n11;
            nArray2[0] = n12;
        }
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n, int n2, int n3) {
        byte[] byArray;
        if (bitArray.getSizeInBytes() != n2) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ArrayList<BlockPair> arrayList = new ArrayList<BlockPair>(n3);
        int n7 = 0;
        while (n7 < n3) {
            int[] nArray = new int[1];
            int[] object2 = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(n, n2, n3, n7, nArray, object2);
            int n8 = nArray[0];
            byArray = new byte[n8];
            bitArray.toBytes(8 * n4, byArray, 0, n8);
            byte[] byArray2 = Encoder.generateECBytes(byArray, object2[0]);
            arrayList.add(new BlockPair(byArray, byArray2));
            n5 = Math.max(n5, n8);
            n6 = Math.max(n6, byArray2.length);
            n4 += nArray[0];
            ++n7;
        }
        if (n2 != n4) {
            throw new WriterException("Data bytes does not match offset");
        }
        BitArray bitArray2 = new BitArray();
        int n9 = 0;
        while (n9 < n5) {
            for (BlockPair blockPair : arrayList) {
                byArray = blockPair.getDataBytes();
                if (n9 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n9], 8);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n6) {
            for (BlockPair blockPair : arrayList) {
                byArray = blockPair.getErrorCorrectionBytes();
                if (n9 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n9], 8);
            }
            ++n9;
        }
        if (n != bitArray2.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n + " and " + bitArray2.getSizeInBytes() + " differ.");
        }
        return bitArray2;
    }

    static byte[] generateECBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2 + n];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = byArray[n3] & 0xFF;
            ++n3;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n);
        byte[] byArray2 = new byte[n];
        int n4 = 0;
        while (n4 < n) {
            byArray2[n4] = (byte)nArray[n2 + n4];
            ++n4;
        }
        return byArray2;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n, Version version, Mode mode, BitArray bitArray) {
        int n2 = mode.getCharacterCountBits(version);
        if (n >= 1 << n2) {
            throw new WriterException(String.valueOf(n) + " is bigger than " + ((1 << n2) - 1));
        }
        bitArray.appendBits(n, n2);
    }

    static void appendBytes(String string, Mode mode, BitArray bitArray, String string2) {
        switch (mode) {
            case NUMERIC: {
                Encoder.appendNumericBytes(string, bitArray);
                break;
            }
            case ALPHANUMERIC: {
                Encoder.appendAlphanumericBytes(string, bitArray);
                break;
            }
            case BYTE: {
                Encoder.append8BitBytes(string, bitArray, string2);
                break;
            }
            case KANJI: {
                Encoder.appendKanjiBytes(string, bitArray);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + (Object)((Object)mode));
            }
        }
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = charSequence.charAt(n2) - 48;
            if (n2 + 2 < n) {
                n3 = charSequence.charAt(n2 + 1) - 48;
                int n5 = charSequence.charAt(n2 + 2) - 48;
                bitArray.appendBits(n4 * 100 + n3 * 10 + n5, 10);
                n2 += 3;
                continue;
            }
            if (n2 + 1 < n) {
                n3 = charSequence.charAt(n2 + 1) - 48;
                bitArray.appendBits(n4 * 10 + n3, 7);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n4, 4);
            ++n2;
        }
    }

    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Encoder.getAlphanumericCode(charSequence.charAt(n2));
            if (n3 == -1) {
                throw new WriterException();
            }
            if (n2 + 1 < n) {
                int n4 = Encoder.getAlphanumericCode(charSequence.charAt(n2 + 1));
                if (n4 == -1) {
                    throw new WriterException();
                }
                bitArray.appendBits(n3 * 45 + n4, 11);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n3, 6);
            ++n2;
        }
    }

    static void append8BitBytes(String string, BitArray bitArray, String string2) {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            bitArray.appendBits(by, 8);
            ++n2;
        }
    }

    static void appendKanjiBytes(String string, BitArray bitArray) {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            int n5 = n3 << 8 | n4;
            int n6 = -1;
            if (n5 >= 33088 && n5 <= 40956) {
                n6 = n5 - 33088;
            } else if (n5 >= 57408 && n5 <= 60351) {
                n6 = n5 - 49472;
            }
            if (n6 == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int n7 = (n6 >> 8) * 192 + (n6 & 0xFF);
            bitArray.appendBits(n7, 13);
            n2 += 2;
        }
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }
}

