/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.encoder;

import oz.util.barcode.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        int n4 = 0;
        while (n4 < n3 - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                byte by = byArray[n4][n5];
                if (by == byArray[n4][n5 + 1] && by == byArray[n4 + 1][n5] && by == byArray[n4 + 1][n5 + 1]) {
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        return 3 * n;
    }

    static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                byte[] byArray2 = byArray[n4];
                if (n5 + 6 < n2 && byArray2[n5] == 1 && byArray2[n5 + 1] == 0 && byArray2[n5 + 2] == 1 && byArray2[n5 + 3] == 1 && byArray2[n5 + 4] == 1 && byArray2[n5 + 5] == 0 && byArray2[n5 + 6] == 1 && (MaskUtil.isWhiteHorizontal(byArray2, n5 - 4, n5) || MaskUtil.isWhiteHorizontal(byArray2, n5 + 7, n5 + 11))) {
                    ++n;
                }
                if (n4 + 6 < n3 && byArray[n4][n5] == 1 && byArray[n4 + 1][n5] == 0 && byArray[n4 + 2][n5] == 1 && byArray[n4 + 3][n5] == 1 && byArray[n4 + 4][n5] == 1 && byArray[n4 + 5][n5] == 0 && byArray[n4 + 6][n5] == 1 && (MaskUtil.isWhiteVertical(byArray, n5, n4 - 4, n4) || MaskUtil.isWhiteVertical(byArray, n5, n4 + 7, n4 + 11))) {
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        return n * 40;
    }

    private static boolean isWhiteHorizontal(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (n3 >= 0 && n3 < byArray.length && byArray[n3] == 1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] byArray, int n, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            if (n4 >= 0 && n4 < byArray.length && byArray[n4][n] == 1) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        int n = 0;
        byte[][] byArray = byteMatrix.getArray();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        int n4 = 0;
        while (n4 < n3) {
            byte[] byArray2 = byArray[n4];
            int n5 = 0;
            while (n5 < n2) {
                if (byArray2[n5] == 1) {
                    ++n;
                }
                ++n5;
            }
            ++n4;
        }
        n4 = byteMatrix.getHeight() * byteMatrix.getWidth();
        int n6 = Math.abs(n * 2 - n4) * 10 / n4;
        return n6 * 10;
    }

    static boolean getDataMaskBit(int n, int n2, int n3) {
        int n4;
        switch (n) {
            case 0: {
                n4 = n3 + n2 & 1;
                break;
            }
            case 1: {
                n4 = n3 & 1;
                break;
            }
            case 2: {
                n4 = n2 % 3;
                break;
            }
            case 3: {
                n4 = (n3 + n2) % 3;
                break;
            }
            case 4: {
                n4 = (n3 >>> 1) + n2 / 3 & 1;
                break;
            }
            case 5: {
                int n5 = n3 * n2;
                n4 = (n5 & 1) + n5 % 3;
                break;
            }
            case 6: {
                int n6 = n3 * n2;
                n4 = (n6 & 1) + n6 % 3 & 1;
                break;
            }
            case 7: {
                int n7 = n3 * n2;
                n4 = n7 % 3 + (n3 + n2 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n);
            }
        }
        return n4 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix byteMatrix, boolean bl) {
        int n = 0;
        int n2 = bl ? byteMatrix.getHeight() : byteMatrix.getWidth();
        int n3 = bl ? byteMatrix.getWidth() : byteMatrix.getHeight();
        byte[][] byArray = byteMatrix.getArray();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            byte by = -1;
            int n6 = 0;
            while (n6 < n3) {
                byte by2;
                byte by3 = by2 = bl ? byArray[n4][n6] : byArray[n6][n4];
                if (by2 == by) {
                    ++n5;
                } else {
                    if (n5 >= 5) {
                        n += 3 + (n5 - 5);
                    }
                    n5 = 1;
                    by = by2;
                }
                ++n6;
            }
            if (n5 >= 5) {
                n += 3 + (n5 - 5);
            }
            ++n4;
        }
        return n;
    }
}

