/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import oz.util.view.camera.CameraBoxView$CameraBox;
import oz.util.view.camera.CameraBoxView$CameraBoxRender;

public class CameraBoxView
extends View {
    private RectF mViewRect = new RectF();
    private RectF mViewTempRect = new RectF();
    private RectF mWholeRect = new RectF();
    private Paint mWholeRectPaint = new Paint(1);
    private RectF mOutRect;
    private Paint mOutRectPaint;
    private RectF mInRect;
    private Paint mInRectPaint;
    private Paint mBitmapPaint;
    private boolean mDrawWholeRect;
    private boolean mDrawOutRect;
    private boolean mDrawInRect;
    private int mBackgroundColor;
    private boolean mDrawBackground;
    private Bitmap mBitmap;
    private RectF mBitmapRect;
    private int mBitmapRotation;
    private boolean mBoxDraw;
    private CameraBoxView$CameraBoxRender mBoxRender;
    private CameraBoxView$CameraBox[] mBox;

    public CameraBoxView(Context context) {
        super(context);
        this.mWholeRectPaint.setARGB(100, 255, 0, 0);
        this.mWholeRectPaint.setStrokeWidth(4.0f);
        this.mWholeRectPaint.setStyle(Paint.Style.STROKE);
        this.mOutRect = new RectF();
        this.mOutRectPaint = new Paint(1);
        this.mOutRectPaint.setARGB(100, 0, 255, 0);
        this.mOutRectPaint.setStrokeWidth(4.0f);
        this.mOutRectPaint.setStyle(Paint.Style.STROKE);
        this.mInRect = new RectF();
        this.mInRectPaint = new Paint(1);
        this.mInRectPaint.setARGB(200, 255, 255, 255);
        this.mInRectPaint.setStrokeWidth(4.0f);
        this.mInRectPaint.setStyle(Paint.Style.STROKE);
        this.mDrawWholeRect = false;
        this.mDrawOutRect = false;
        this.mDrawInRect = true;
        this.mDrawBackground = true;
        this.mBackgroundColor = Color.argb((int)150, (int)0, (int)0, (int)0);
        this.mBitmapPaint = new Paint(1);
        this.mBitmapRect = new RectF();
    }

    public RectF getWholeRect() {
        return this.mWholeRect;
    }

    public RectF getOutRect() {
        return this.mOutRect;
    }

    public RectF getInRect() {
        return this.mInRect;
    }

    public void setDrawInRect(boolean bl) {
        if (this.mDrawInRect != bl) {
            this.mDrawInRect = bl;
            this.postInvalidate();
        }
    }

    public void setBoxBitmap(Bitmap bitmap, int n, RectF rectF) {
        this.mBitmapRotation = n;
        if (rectF == null) {
            this.mBitmapRect.setEmpty();
        } else {
            this.mBitmapRect.set(rectF);
        }
        if (bitmap != this.mBitmap) {
            Bitmap bitmap2 = this.mBitmap;
            this.mBitmap = bitmap;
            this.postInvalidate();
            if (bitmap2 != null) {
                bitmap2.recycle();
            }
        }
    }

    public void setBoxDraw(boolean bl) {
        this.mBoxDraw = bl;
    }

    public void setBox(CameraBoxView$CameraBox[] cameraBoxView$CameraBoxArray) {
        this.mBox = cameraBoxView$CameraBoxArray;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mViewRect.set(0.0f, 0.0f, (float)n, (float)n2);
    }

    private void drawRect(Canvas canvas, RectF rectF, Paint paint) {
        if (!rectF.isEmpty()) {
            this.mViewTempRect.setIntersect(this.mViewRect, rectF);
            if (!this.mViewTempRect.isEmpty()) {
                canvas.drawRect(this.mViewTempRect, paint);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBitmap != null) {
            canvas.save();
            if (this.mBitmapRotation != 0) {
                canvas.rotate((float)this.mBitmapRotation, (float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2));
            }
            canvas.drawBitmap(this.mBitmap, new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight()), this.mBitmapRect, this.mBitmapPaint);
            canvas.restore();
        }
        if (this.mDrawBackground && !this.mWholeRect.isEmpty()) {
            canvas.save();
            this.mViewTempRect.setIntersect(this.mViewRect, this.mWholeRect);
            if (!this.mViewTempRect.isEmpty()) {
                Path path = new Path();
                path.addRect(this.mViewTempRect, Path.Direction.CW);
                this.mViewTempRect.setIntersect(this.mViewRect, this.mInRect);
                if (!this.mViewTempRect.isEmpty()) {
                    Path path2 = new Path();
                    path2.addRect(this.mViewTempRect, Path.Direction.CW);
                    path.op(path, path2, Path.Op.DIFFERENCE);
                }
                canvas.clipPath(path);
            }
            canvas.drawColor(this.mBackgroundColor);
            canvas.restore();
        }
        if (this.mDrawWholeRect) {
            this.drawRect(canvas, this.mWholeRect, this.mWholeRectPaint);
        }
        if (this.mDrawOutRect) {
            this.drawRect(canvas, this.mOutRect, this.mOutRectPaint);
        }
        if (this.mDrawInRect) {
            this.drawRect(canvas, this.mInRect, this.mInRectPaint);
        }
        if (this.mBoxDraw && this.mBox != null && this.mBox.length > 0) {
            if (this.mBoxRender == null) {
                this.mBoxRender = new CameraBoxView$CameraBoxRender();
            }
            this.mBoxRender.render(canvas, this.mBox);
        }
    }
}

