/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFConfirmButton$1;
import oz.viewer.ui.df.view.DFConfirmButton$2;

public class DFConfirmButton
extends LinearLayout {
    private static final int COLOR_TEXT = -1;
    private static final int COLOR_BACKGROUND = Color.rgb((int)55, (int)132, (int)236);
    private static final String STRING_OK = "OK";
    private static final int SP_TEXT = 24;
    private static final int DP_IMAGE_MARGIN = 10;
    private static final int DP_IMAGE_WIDTH = 15;
    private static final int DP_IMAGE_HEIGHT = 10;
    private Drawable mBackground;
    private String mButtonText;

    public DFConfirmButton(Context context, String string) {
        super(context);
        this.mButtonText = string;
        this.init();
    }

    public void init() {
        this.setOrientation(0);
        this.setWillNotDraw(false);
        this.setGravity(17);
        this.setBackground(null);
        TextView textView = new TextView(this.getContext());
        textView.setTextColor(-1);
        textView.setTextSize(24.0f);
        textView.setText((CharSequence)(this.mButtonText.isEmpty() ? STRING_OK : this.mButtonText));
        textView.setTypeface(null, 1);
        textView.setClickable(false);
        textView.setOnTouchListener((View.OnTouchListener)new DFConfirmButton$1(this));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.rightMargin = DFUtils.toDP(this.getContext(), 10.0f);
        this.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(DFUtils.getImageDrawable(this.getContext(), 11));
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView.setClickable(false);
        imageView.setOnTouchListener((View.OnTouchListener)new DFConfirmButton$2(this));
        layoutParams = new LinearLayout.LayoutParams(DFUtils.toDP(this.getContext(), 15.0f), DFUtils.toDP(this.getContext(), 10.0f));
        this.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
    }

    private Drawable createBackground(int n, int n2) {
        float f2 = (float)n2 / 2.0f;
        RoundRectShape roundRectShape = new RoundRectShape(new float[]{f2, f2, f2, f2, f2, f2, f2, f2}, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(COLOR_BACKGROUND);
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.setBounds(0, 0, n, n2);
        return shapeDrawable;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n == 0 || n2 == 0) {
            this.mBackground = null;
        } else if (this.mBackground == null || n2 != n4) {
            this.mBackground = this.createBackground(n, n2);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.draw(canvas);
        }
        super.onDraw(canvas);
    }
}

