/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import oz.main.OZStorage;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.ATableManager;
import oz.viewer.ui.main.overlay.ATableView$1;
import oz.viewer.ui.main.overlay.ATableView$AThumbnailInfo;
import oz.viewer.ui.main.overlay.ATableView$AThumbnailSubjectTypeface;
import oz.viewer.ui.main.overlay.ATableView$TableHandler;
import oz.viewer.ui.main.overlay.ATableView$TableListView;
import oz.viewer.ui.main.overlay.ATableView$ThumbnailTaskManager;
import oz.viewer.ui.main.overlay.ATableView$ToggleButton;

public class ATableView
extends FrameLayout {
    private static final int MINIMUM_WIDTH = 100;
    private ATableManager mManager;
    private ATableView$ThumbnailTaskManager mThumbnailTaskManager;
    private LinearLayout mListLayout;
    private LinearLayout mTableListWrapper;
    private ATableView$ToggleButton mToggleBtnView;
    private ATableView$TableListView mTableListView;
    private int mMinSize;
    private boolean mIsSlide;
    private boolean mIsShowTable;
    private int mRealWidth;
    private ATableView$TableHandler mHandler;
    private ATableView$AThumbnailSubjectTypeface mThumbnailTypeface;
    private static float THUMBNAIL_TEXT_SIZE = 0.0f;

    public ATableView(Context context) {
        super(context);
        this.setThumbnailTypeface(new ATableView$AThumbnailSubjectTypeface());
        this.mHandler = new ATableView$TableHandler(this, null);
        this.mMinSize = AOverlayUtil.DpToPx(100);
        this.mThumbnailTaskManager = new ATableView$ThumbnailTaskManager(this);
        this.mToggleBtnView = new ATableView$ToggleButton(this, this.getContext());
        this.mTableListView = new ATableView$TableListView(this, this.getContext());
        this.mTableListView.setBackgroundColor(-1);
        this.mListLayout = new LinearLayout(this.getContext());
        this.mListLayout.setOrientation(0);
        this.mListLayout.setGravity(17);
        this.mTableListWrapper = new LinearLayout(this.getContext());
        this.mTableListWrapper.setBackgroundColor(-1);
        this.mTableListWrapper.addView((View)this.mTableListView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mListLayout.addView((View)this.mTableListWrapper, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(1, -1, 1.0f));
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.addView((View)this.mToggleBtnView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mToggleBtnView.getButtonWidth(), this.mToggleBtnView.getButtonHeight(), 17));
        frameLayout.addView(new View(this.getContext()), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1, 80));
        this.mListLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        this.mIsShowTable = false;
        this.mListLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, -1, 51));
        this.setRealWidth(this.getMinimumRealWidth() * 2);
        this.updateViewWidth();
        this.addView((View)this.mListLayout);
    }

    public void setEmptyMode() {
        this.mTableListView.setEmptyData();
    }

    public int getRealWidth(boolean bl) {
        if (bl) {
            return this.mRealWidth + this.mToggleBtnView.getButtonWidth();
        }
        return this.mRealWidth;
    }

    public void setRealWidth(int n) {
        int n2 = Math.max(Math.min(this.getMaximumRealWidth(), n), this.getMinimumRealWidth());
        if (n2 != this.mRealWidth) {
            this.mRealWidth = n2;
            this.mHandler.sizeChanged();
        }
    }

    public void updateViewWidth() {
        this.updateViewWidth(this.isShowTable());
    }

    public void updateViewWidth(boolean bl) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mListLayout.getLayoutParams();
        layoutParams.width = this.getRealWidth(true);
        layoutParams.leftMargin = bl ? 0 : -this.getRealWidth(false);
        this.mListLayout.requestLayout();
        this.mListLayout.invalidate();
    }

    public int getMinimumRealWidth() {
        return this.mMinSize;
    }

    public int getMaximumRealWidth() {
        if (this.getParent() != null) {
            int n = ((View)this.getParent()).getWidth();
            if (n == 0) {
                n = OZStorage.getScreenSize((Context)this.getContext()).x;
            }
            return Math.max(n - this.mToggleBtnView.getButtonWidth(), this.getMinimumRealWidth() * 2);
        }
        return this.getMinimumRealWidth() * 2;
    }

    public View getToggleBtn() {
        return this.mToggleBtnView;
    }

    public void setManager(ATableManager aTableManager) {
        this.mManager = aTableManager;
    }

    public ATableManager getManager() {
        return this.mManager;
    }

    public ATableView$ThumbnailTaskManager getThumbnailTaskManager() {
        return this.mThumbnailTaskManager;
    }

    public int getVisibleWidth() {
        return this.isShowTable() ? this.mRealWidth : 0;
    }

    public boolean getTouchVisible() {
        return this.getVisibleWidth() > 0;
    }

    public void setTreeMode(String[] stringArray) {
        this.mTableListView.setTreeData(stringArray);
    }

    public void setThumbnailInfo(ATableView$AThumbnailInfo aTableView$AThumbnailInfo) {
        this.mTableListView.setThumbnailInfo(aTableView$AThumbnailInfo);
    }

    public void setThumbnailMode(boolean bl) {
        this.mTableListView.setThumbnailData(bl);
    }

    public void setHeaderTitle(String string) {
        this.mTableListView.setHeaderTitleText(string);
    }

    public void setItemSelect(int n) {
        this.mTableListView.setSelection(n);
    }

    public void scrollToSelectedItem() {
        int n = ATableView$TableListView.access$100(this.mTableListView);
        if (n < 0) {
            this.mTableListView.setSelectionAfterHeaderView();
        } else {
            this.mTableListView.setSelection(n);
        }
    }

    public void initThumbnail() {
        this.mTableListView.initThumbnail();
    }

    public void updateThumbnail() {
        this.getThumbnailTaskManager().clearBitmap();
        this.getThumbnailTaskManager().clearTask();
        this.mHandler.changedListDelay(0);
    }

    public void updateThumbnail(int n) {
        this.getThumbnailTaskManager().removeBitmap(n);
        this.getThumbnailTaskManager().removeTask(n);
        this.mHandler.changedListDelay(0);
    }

    public void clearToggleTouch() {
        ATableView$ToggleButton.access$202(this.mToggleBtnView, false);
        ATableView$ToggleButton.access$302(this.mToggleBtnView, false);
        this.updateToggleButton();
    }

    public void updateToggleButton() {
        this.mToggleBtnView.invalidate();
    }

    public boolean getTableViewVisble() {
        return this.mTableListView.getVisibility() == 0;
    }

    public void setTableViewVisible(boolean bl) {
        if (this.getTableViewVisble() != bl) {
            if (bl) {
                this.mTableListView.setVisibility(0);
            } else {
                this.mTableListView.setVisibility(4);
            }
        }
    }

    public void openTable() {
        if (!this.isShowTable()) {
            this.setTableViewVisible(true);
            this.mIsShowTable = true;
            this.mHandler.sizeChanged();
            this.clearToggleTouch();
            this.updateThumbnail();
        }
    }

    public void closeTable() {
        if (this.isShowTable()) {
            this.setTableViewVisible(false);
            this.mIsShowTable = false;
            this.mHandler.sizeChanged();
            this.clearToggleTouch();
        }
    }

    public void toggleTable() {
        if (this.isShowTable()) {
            this.closeTable();
        } else {
            this.openTable();
        }
    }

    private Animation getToggleTableAnimation(boolean bl) {
        TranslateAnimation translateAnimation = null;
        translateAnimation = bl ? new TranslateAnimation(0.0f, (float)(-this.getRealWidth(false)), 0.0f, 0.0f) : new TranslateAnimation(0.0f, (float)this.getRealWidth(false), 0.0f, 0.0f);
        translateAnimation.setStartOffset(30L);
        translateAnimation.setDuration(200L);
        translateAnimation.setFillBefore(false);
        translateAnimation.setFillEnabled(true);
        translateAnimation.setAnimationListener((Animation.AnimationListener)new ATableView$1(this));
        return translateAnimation;
    }

    public void toggleTableAnimation() {
        this.setTableViewVisible(true);
        this.mHandler.requestToggleAnimation();
    }

    public boolean isShowTable() {
        return this.mIsShowTable;
    }

    private float getThumbnailTextSize() {
        if (this.getThumbnailTypeface().getSize() <= 0.0f) {
            return this.getTreeTextSize();
        }
        return this.getThumbnailTypeface().getSize();
    }

    private float getTreeTextSize() {
        if (THUMBNAIL_TEXT_SIZE <= 0.0f) {
            THUMBNAIL_TEXT_SIZE = new TextView(this.getContext()).getTextSize();
        }
        return THUMBNAIL_TEXT_SIZE;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.setRealWidth(this.getRealWidth(false));
        this.updateViewWidth();
    }

    public ATableView$AThumbnailSubjectTypeface getThumbnailTypeface() {
        return this.mThumbnailTypeface;
    }

    public void setThumbnailTypeface(ATableView$AThumbnailSubjectTypeface aTableView$AThumbnailSubjectTypeface) {
        this.mThumbnailTypeface = aTableView$AThumbnailSubjectTypeface;
    }

    static /* synthetic */ boolean access$402(ATableView aTableView, boolean bl) {
        aTableView.mIsSlide = bl;
        return aTableView.mIsSlide;
    }

    static /* synthetic */ ATableView$TableListView access$500(ATableView aTableView) {
        return aTableView.mTableListView;
    }

    static /* synthetic */ ATableView$TableHandler access$700(ATableView aTableView) {
        return aTableView.mHandler;
    }

    static /* synthetic */ float access$800(ATableView aTableView) {
        return aTableView.getTreeTextSize();
    }

    static /* synthetic */ boolean access$400(ATableView aTableView) {
        return aTableView.mIsSlide;
    }

    static /* synthetic */ float access$1300(ATableView aTableView) {
        return aTableView.getThumbnailTextSize();
    }

    static /* synthetic */ Animation access$1500(ATableView aTableView, boolean bl) {
        return aTableView.getToggleTableAnimation(bl);
    }

    static /* synthetic */ LinearLayout access$1600(ATableView aTableView) {
        return aTableView.mListLayout;
    }
}

