/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import android.annotation.TargetApi;
import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.bluetooth.ChromeBluetoothDevice;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
@TargetApi(value=21)
final class ChromeBluetoothRemoteGattCharacteristic {
    private static final String TAG = "Bluetooth";
    private long mNativeBluetoothRemoteGattCharacteristicAndroid;
    final Wrappers.BluetoothGattCharacteristicWrapper mCharacteristic;
    final String mInstanceId;
    final ChromeBluetoothDevice mChromeDevice;

    private ChromeBluetoothRemoteGattCharacteristic(long nativeBluetoothRemoteGattCharacteristicAndroid, Wrappers.BluetoothGattCharacteristicWrapper characteristicWrapper, String instanceId, ChromeBluetoothDevice chromeDevice) {
        this.mNativeBluetoothRemoteGattCharacteristicAndroid = nativeBluetoothRemoteGattCharacteristicAndroid;
        this.mCharacteristic = characteristicWrapper;
        this.mInstanceId = instanceId;
        this.mChromeDevice = chromeDevice;
        this.mChromeDevice.mWrapperToChromeCharacteristicsMap.put(characteristicWrapper, this);
        Log.v(TAG, "ChromeBluetoothRemoteGattCharacteristic created.");
    }

    @CalledByNative
    private void onBluetoothRemoteGattCharacteristicAndroidDestruction() {
        Log.v(TAG, "ChromeBluetoothRemoteGattCharacteristic Destroyed.");
        if (this.mChromeDevice.mBluetoothGatt != null) {
            this.mChromeDevice.mBluetoothGatt.setCharacteristicNotification(this.mCharacteristic, false);
        }
        this.mNativeBluetoothRemoteGattCharacteristicAndroid = 0L;
        this.mChromeDevice.mWrapperToChromeCharacteristicsMap.remove(this.mCharacteristic);
    }

    void onCharacteristicChanged() {
        Log.i(TAG, "onCharacteristicChanged", new Object[0]);
        if (this.mNativeBluetoothRemoteGattCharacteristicAndroid != 0L) {
            this.nativeOnChanged(this.mNativeBluetoothRemoteGattCharacteristicAndroid, this.mCharacteristic.getValue());
        }
    }

    void onCharacteristicRead(int status) {
        Log.i(TAG, "onCharacteristicRead status:%d==%s", status, status == 0 ? "OK" : "Error");
        if (this.mNativeBluetoothRemoteGattCharacteristicAndroid != 0L) {
            this.nativeOnRead(this.mNativeBluetoothRemoteGattCharacteristicAndroid, status, this.mCharacteristic.getValue());
        }
    }

    void onCharacteristicWrite(int status) {
        Log.i(TAG, "onCharacteristicWrite status:%d==%s", status, status == 0 ? "OK" : "Error");
        if (this.mNativeBluetoothRemoteGattCharacteristicAndroid != 0L) {
            this.nativeOnWrite(this.mNativeBluetoothRemoteGattCharacteristicAndroid, status);
        }
    }

    @CalledByNative
    private static ChromeBluetoothRemoteGattCharacteristic create(long nativeBluetoothRemoteGattCharacteristicAndroid, Object bluetoothGattCharacteristicWrapper, String instanceId, ChromeBluetoothDevice chromeDevice) {
        return new ChromeBluetoothRemoteGattCharacteristic(nativeBluetoothRemoteGattCharacteristicAndroid, (Wrappers.BluetoothGattCharacteristicWrapper)bluetoothGattCharacteristicWrapper, instanceId, chromeDevice);
    }

    @CalledByNative
    private String getUUID() {
        return this.mCharacteristic.getUuid().toString();
    }

    @CalledByNative
    private int getProperties() {
        return this.mCharacteristic.getProperties();
    }

    @CalledByNative
    private boolean readRemoteCharacteristic() {
        if (!this.mChromeDevice.mBluetoothGatt.readCharacteristic(this.mCharacteristic)) {
            Log.i(TAG, "readRemoteCharacteristic readCharacteristic failed.", new Object[0]);
            return false;
        }
        return true;
    }

    @CalledByNative
    private boolean writeRemoteCharacteristic(byte[] value) {
        if (!this.mCharacteristic.setValue(value)) {
            Log.i(TAG, "writeRemoteCharacteristic setValue failed.", new Object[0]);
            return false;
        }
        if (!this.mChromeDevice.mBluetoothGatt.writeCharacteristic(this.mCharacteristic)) {
            Log.i(TAG, "writeRemoteCharacteristic writeCharacteristic failed.", new Object[0]);
            return false;
        }
        return true;
    }

    @CalledByNative
    private boolean setCharacteristicNotification(boolean enabled) {
        return this.mChromeDevice.mBluetoothGatt.setCharacteristicNotification(this.mCharacteristic, enabled);
    }

    @CalledByNative
    private void createDescriptors() {
        List<Wrappers.BluetoothGattDescriptorWrapper> descriptors = this.mCharacteristic.getDescriptors();
        int instanceIdCounter = 0;
        for (Wrappers.BluetoothGattDescriptorWrapper descriptor : descriptors) {
            String descriptorInstanceId = this.mInstanceId + "/" + descriptor.getUuid().toString() + ";" + instanceIdCounter++;
            this.nativeCreateGattRemoteDescriptor(this.mNativeBluetoothRemoteGattCharacteristicAndroid, descriptorInstanceId, descriptor, this.mChromeDevice);
        }
    }

    native void nativeOnChanged(long var1, byte[] var3);

    native void nativeOnRead(long var1, int var3, byte[] var4);

    native void nativeOnWrite(long var1, int var3);

    private native void nativeCreateGattRemoteDescriptor(long var1, String var3, Object var4, Object var5);
}

