/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.power_save_blocker;

import android.view.View;
import java.lang.ref.WeakReference;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.ui.base.ViewAndroidDelegate;

@JNINamespace(value="device")
class PowerSaveBlocker {
    private WeakReference<View> mKeepScreenOnView;

    @CalledByNative
    private static PowerSaveBlocker create() {
        return new PowerSaveBlocker();
    }

    private PowerSaveBlocker() {
    }

    @CalledByNative
    private void applyBlock(ViewAndroidDelegate delegate) {
        assert (this.mKeepScreenOnView == null);
        View anchorView = delegate.acquireAnchorView();
        this.mKeepScreenOnView = new WeakReference<View>(anchorView);
        delegate.setAnchorViewPosition(anchorView, 0.0f, 0.0f, 0.0f, 0.0f);
        anchorView.setKeepScreenOn(true);
    }

    @CalledByNative
    private void removeBlock(ViewAndroidDelegate delegate) {
        assert (this.mKeepScreenOnView != null);
        View anchorView = (View)this.mKeepScreenOnView.get();
        this.mKeepScreenOnView = null;
        if (anchorView == null) {
            return;
        }
        anchorView.setKeepScreenOn(false);
        delegate.releaseAnchorView(anchorView);
    }
}

