/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.vibration;

import android.content.Context;
import android.media.AudioManager;
import android.os.Vibrator;
import android.util.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojom.device.VibrationManager;

public class VibrationManagerImpl
implements VibrationManager {
    private static final String TAG = "VibrationManagerImpl";
    private static final long MINIMUM_VIBRATION_DURATION_MS = 1L;
    private static final long MAXIMUM_VIBRATION_DURATION_MS = 10000L;
    private final AudioManager mAudioManager;
    private final Vibrator mVibrator;
    private final boolean mHasVibratePermission;
    private static AndroidVibratorWrapper sVibratorWrapper;

    public static void setVibratorWrapperForTesting(AndroidVibratorWrapper wrapper) {
        sVibratorWrapper = wrapper;
    }

    public VibrationManagerImpl(Context context) {
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        if (sVibratorWrapper == null) {
            sVibratorWrapper = new AndroidVibratorWrapper();
        }
        boolean bl = this.mHasVibratePermission = context.checkCallingOrSelfPermission("android.permission.VIBRATE") == 0;
        if (!this.mHasVibratePermission) {
            Log.w((String)TAG, (String)"Failed to use vibrate API, requires VIBRATE permission.");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void onConnectionError(MojoException e) {
    }

    @Override
    public void vibrate(long milliseconds, VibrationManager.VibrateResponse callback) {
        long sanitizedMilliseconds = Math.max(1L, Math.min(milliseconds, 10000L));
        if (this.mAudioManager.getRingerMode() != 0 && this.mHasVibratePermission) {
            sVibratorWrapper.vibrate(this.mVibrator, sanitizedMilliseconds);
        }
        callback.call();
    }

    @Override
    public void cancel(VibrationManager.CancelResponse callback) {
        if (this.mHasVibratePermission) {
            sVibratorWrapper.cancel(this.mVibrator);
        }
        callback.call();
    }

    @VisibleForTesting
    public static class AndroidVibratorWrapper {
        protected AndroidVibratorWrapper() {
        }

        public void vibrate(Vibrator vibrator, long milliseconds) {
            vibrator.vibrate(milliseconds);
        }

        public void cancel(Vibrator vibrator) {
            vibrator.cancel();
        }
    }
}

