/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media.midi;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.midi.MidiDevice;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiManager;
import android.os.Handler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.midi.MidiDeviceAndroid;

@JNINamespace(value="media::midi")
@TargetApi(value=23)
class MidiManagerAndroid {
    private boolean mIsInitializing = true;
    private final List<MidiDeviceAndroid> mDevices = new ArrayList<MidiDeviceAndroid>();
    private final Set<MidiDeviceInfo> mPendingDevices = new HashSet<MidiDeviceInfo>();
    private final MidiManager mManager;
    private final Handler mHandler;
    private final long mNativeManagerPointer;

    @CalledByNative
    static MidiManagerAndroid create(Context context, long nativeManagerPointer) {
        return new MidiManagerAndroid(context, nativeManagerPointer);
    }

    MidiManagerAndroid(Context context, long nativeManagerPointer) {
        assert (ThreadUtils.runningOnUiThread());
        this.mManager = (MidiManager)context.getSystemService("midi");
        this.mHandler = new Handler(ThreadUtils.getUiThreadLooper());
        this.mNativeManagerPointer = nativeManagerPointer;
    }

    @CalledByNative
    void initialize() {
        MidiDeviceInfo[] infos;
        this.mManager.registerDeviceCallback(new MidiManager.DeviceCallback(){

            public void onDeviceAdded(MidiDeviceInfo device) {
                MidiManagerAndroid.this.onDeviceAdded(device);
            }

            public void onDeviceRemoved(MidiDeviceInfo device) {
                MidiManagerAndroid.this.onDeviceRemoved(device);
            }
        }, this.mHandler);
        for (MidiDeviceInfo info : infos = this.mManager.getDevices()) {
            this.mPendingDevices.add(info);
            this.openDevice(info);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (MidiManagerAndroid.this.mPendingDevices.isEmpty() && MidiManagerAndroid.this.mIsInitializing) {
                    MidiManagerAndroid.nativeOnInitialized(MidiManagerAndroid.this.mNativeManagerPointer, MidiManagerAndroid.this.mDevices.toArray(new MidiDeviceAndroid[0]));
                    MidiManagerAndroid.this.mIsInitializing = false;
                }
            }
        });
    }

    private void openDevice(final MidiDeviceInfo info) {
        this.mManager.openDevice(info, new MidiManager.OnDeviceOpenedListener(){

            public void onDeviceOpened(MidiDevice device) {
                MidiManagerAndroid.this.onDeviceOpened(device, info);
            }
        }, this.mHandler);
    }

    private void onDeviceAdded(MidiDeviceInfo info) {
        if (this.mIsInitializing) {
            this.mPendingDevices.add(info);
        }
        this.openDevice(info);
    }

    private void onDeviceRemoved(MidiDeviceInfo info) {
        for (MidiDeviceAndroid device : this.mDevices) {
            if (!device.isOpen() || device.getInfo().getId() != info.getId()) continue;
            device.close();
            MidiManagerAndroid.nativeOnDetached(this.mNativeManagerPointer, device);
        }
    }

    private void onDeviceOpened(MidiDevice device, MidiDeviceInfo info) {
        this.mPendingDevices.remove(info);
        if (device != null) {
            MidiDeviceAndroid xdevice = new MidiDeviceAndroid(device);
            this.mDevices.add(xdevice);
            if (!this.mIsInitializing) {
                MidiManagerAndroid.nativeOnAttached(this.mNativeManagerPointer, xdevice);
            }
        }
        if (this.mIsInitializing && this.mPendingDevices.isEmpty()) {
            MidiManagerAndroid.nativeOnInitialized(this.mNativeManagerPointer, this.mDevices.toArray(new MidiDeviceAndroid[0]));
            this.mIsInitializing = false;
        }
    }

    static native void nativeOnInitialized(long var0, MidiDeviceAndroid[] var2);

    static native void nativeOnAttached(long var0, MidiDeviceAndroid var2);

    static native void nativeOnDetached(long var0, MidiDeviceAndroid var2);
}

