/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system;

import java.nio.ByteBuffer;
import java.util.List;
import org.chromium.mojo.system.Flags;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.ResultAnd;
import org.chromium.mojo.system.UntypedHandle;

public interface MessagePipeHandle
extends Handle {
    @Override
    public MessagePipeHandle pass();

    public void writeMessage(ByteBuffer var1, List<? extends Handle> var2, WriteFlags var3);

    public ResultAnd<ReadMessageResult> readMessage(ByteBuffer var1, int var2, ReadFlags var3);

    public static class ReadMessageResult {
        private int mMessageSize;
        private int mHandlesCount;
        private List<UntypedHandle> mHandles;

        public int getMessageSize() {
            return this.mMessageSize;
        }

        public void setMessageSize(int messageSize) {
            this.mMessageSize = messageSize;
        }

        public int getHandlesCount() {
            return this.mHandlesCount;
        }

        public void setHandlesCount(int handlesCount) {
            this.mHandlesCount = handlesCount;
        }

        public List<UntypedHandle> getHandles() {
            return this.mHandles;
        }

        public void setHandles(List<UntypedHandle> handles) {
            this.mHandles = handles;
        }
    }

    public static class ReadFlags
    extends Flags<ReadFlags> {
        private static final int FLAG_NONE = 0;
        private static final int FLAG_MAY_DISCARD = 1;
        public static final ReadFlags NONE = (ReadFlags)ReadFlags.none().immutable();

        private ReadFlags(int flags) {
            super(flags);
        }

        public ReadFlags setMayDiscard(boolean mayDiscard) {
            return (ReadFlags)this.setFlag(1, mayDiscard);
        }

        public static ReadFlags none() {
            return new ReadFlags(0);
        }
    }

    public static class WriteFlags
    extends Flags<WriteFlags> {
        private static final int FLAG_NONE = 0;
        public static final WriteFlags NONE = (WriteFlags)WriteFlags.none().immutable();

        private WriteFlags(int flags) {
            super(flags);
        }

        public static WriteFlags none() {
            return new WriteFlags(0);
        }
    }

    public static class CreateOptions {
        private CreateFlags mFlags = CreateFlags.NONE;

        public CreateFlags getFlags() {
            return this.mFlags;
        }
    }

    public static class CreateFlags
    extends Flags<CreateFlags> {
        private static final int FLAG_NONE = 0;
        public static final CreateFlags NONE = (CreateFlags)CreateFlags.none().immutable();

        protected CreateFlags(int flags) {
            super(flags);
        }

        public static CreateFlags none() {
            return new CreateFlags(0);
        }
    }
}

