/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import java.lang.ref.WeakReference;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.Callback;
import org.chromium.base.ContextUtils;
import org.chromium.ui.UiUtils;
import org.chromium.ui.base.AndroidPermissionDelegate;
import org.chromium.ui.base.WindowAndroid;

public class ActivityWindowAndroid
extends WindowAndroid
implements ApplicationStatus.ActivityStateListener,
View.OnLayoutChangeListener {
    private static final int REQUEST_CODE_PREFIX = 1000;
    private static final int REQUEST_CODE_RANGE_SIZE = 100;
    private static final String PERMISSION_QUERIED_KEY_PREFIX = "HasRequestedAndroidPermission::";
    private final Handler mHandler;
    private final SparseArray<WindowAndroid.PermissionCallback> mOutstandingPermissionRequests;
    private int mNextRequestCode = 0;

    public ActivityWindowAndroid(Context context) {
        this(context, true);
    }

    public ActivityWindowAndroid(Context context, boolean listenToActivityState) {
        super(context);
        Activity activity = ActivityWindowAndroid.activityFromContext(context);
        if (activity == null) {
            throw new IllegalArgumentException("Context is not and does not wrap an Activity");
        }
        this.mHandler = new Handler();
        this.mOutstandingPermissionRequests = new SparseArray();
        if (listenToActivityState) {
            ApplicationStatus.registerStateListenerForActivity(this, activity);
        }
        this.setAndroidPermissionDelegate(new ActivityAndroidPermissionDelegate());
    }

    @Override
    protected void registerKeyboardVisibilityCallbacks() {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return;
        }
        View content = activity.findViewById(0x1020002);
        this.mIsKeyboardShowing = UiUtils.isKeyboardShowing((Context)this.getActivity().get(), content);
        content.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @Override
    protected void unregisterKeyboardVisibilityCallbacks() {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return;
        }
        activity.findViewById(0x1020002).removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    @Override
    public int showCancelableIntent(PendingIntent intent, WindowAndroid.IntentCallback callback, Integer errorId) {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startIntentSenderForResult(intent.getIntentSender(), requestCode, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public int showCancelableIntent(Intent intent, WindowAndroid.IntentCallback callback, Integer errorId) {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        try {
            activity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            return -1;
        }
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public int showCancelableIntent(Callback<Integer> intentTrigger, WindowAndroid.IntentCallback callback, Integer errorId) {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return -1;
        }
        int requestCode = this.generateNextRequestCode();
        intentTrigger.onResult(requestCode);
        this.storeCallbackData(requestCode, callback, errorId);
        return requestCode;
    }

    @Override
    public void cancelIntent(int requestCode) {
        Activity activity = (Activity)this.getActivity().get();
        if (activity == null) {
            return;
        }
        activity.finishActivity(requestCode);
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        WindowAndroid.IntentCallback callback = (WindowAndroid.IntentCallback)this.mOutstandingIntents.get(requestCode);
        this.mOutstandingIntents.delete(requestCode);
        String errorMessage = (String)this.mIntentErrors.remove(requestCode);
        if (callback != null) {
            callback.onIntentCompleted(this, resultCode, this.mApplicationContext.getContentResolver(), data);
            return true;
        }
        if (errorMessage != null) {
            this.showCallbackNonExistentError(errorMessage);
            return true;
        }
        return false;
    }

    private String getHasRequestedPermissionKey(String permission) {
        String permissionQueriedKey = permission;
        try {
            PermissionInfo permissionInfo = this.getApplicationContext().getPackageManager().getPermissionInfo(permission, 128);
            if (!TextUtils.isEmpty((CharSequence)permissionInfo.group)) {
                permissionQueriedKey = permissionInfo.group;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return PERMISSION_QUERIED_KEY_PREFIX + permissionQueriedKey;
    }

    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Activity activity = (Activity)this.getActivity().get();
        assert (activity != null);
        SharedPreferences.Editor editor = ContextUtils.getAppSharedPreferences().edit();
        for (int i = 0; i < permissions.length; ++i) {
            editor.putBoolean(this.getHasRequestedPermissionKey(permissions[i]), true);
        }
        editor.apply();
        WindowAndroid.PermissionCallback callback = (WindowAndroid.PermissionCallback)this.mOutstandingPermissionRequests.get(requestCode);
        this.mOutstandingPermissionRequests.delete(requestCode);
        if (callback == null) {
            return false;
        }
        callback.onRequestPermissionsResult(permissions, grantResults);
        return true;
    }

    @Override
    public WeakReference<Activity> getActivity() {
        return new WeakReference<Activity>(ActivityWindowAndroid.activityFromContext((Context)this.getContext().get()));
    }

    @Override
    public void onActivityStateChange(Activity activity, int newState) {
        if (newState == 5) {
            this.onActivityStopped();
        } else if (newState == 2) {
            this.onActivityStarted();
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.keyboardVisibilityPossiblyChanged(UiUtils.isKeyboardShowing((Context)this.getActivity().get(), v));
    }

    private int generateNextRequestCode() {
        int requestCode = 1000 + this.mNextRequestCode;
        this.mNextRequestCode = (this.mNextRequestCode + 1) % 100;
        return requestCode;
    }

    private void storeCallbackData(int requestCode, WindowAndroid.IntentCallback callback, Integer errorId) {
        this.mOutstandingIntents.put(requestCode, (Object)callback);
        this.mIntentErrors.put(requestCode, errorId == null ? null : this.mApplicationContext.getString(errorId.intValue()));
    }

    private class ActivityAndroidPermissionDelegate
    implements AndroidPermissionDelegate {
        private ActivityAndroidPermissionDelegate() {
        }

        @Override
        public boolean hasPermission(String permission) {
            return ApiCompatibilityUtils.checkPermission(ActivityWindowAndroid.this.mApplicationContext, permission, Process.myPid(), Process.myUid()) == 0;
        }

        @Override
        public boolean canRequestPermission(String permission) {
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            Activity activity = (Activity)ActivityWindowAndroid.this.getActivity().get();
            if (activity == null) {
                return false;
            }
            if (this.isPermissionRevokedByPolicy(permission)) {
                return false;
            }
            if (activity.shouldShowRequestPermissionRationale(permission)) {
                return true;
            }
            String permissionQueriedKey = ActivityWindowAndroid.this.getHasRequestedPermissionKey(permission);
            SharedPreferences prefs = ContextUtils.getAppSharedPreferences();
            return !prefs.getBoolean(permissionQueriedKey, false);
        }

        @Override
        public boolean isPermissionRevokedByPolicy(String permission) {
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            Activity activity = (Activity)ActivityWindowAndroid.this.getActivity().get();
            if (activity == null) {
                return false;
            }
            return activity.getPackageManager().isPermissionRevokedByPolicy(permission, activity.getPackageName());
        }

        @Override
        public void requestPermissions(final String[] permissions, final WindowAndroid.PermissionCallback callback) {
            if (this.requestPermissionsInternal(permissions, callback)) {
                return;
            }
            ActivityWindowAndroid.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    int[] results = new int[permissions.length];
                    for (int i = 0; i < permissions.length; ++i) {
                        results[i] = ActivityAndroidPermissionDelegate.this.hasPermission(permissions[i]) ? 0 : -1;
                    }
                    callback.onRequestPermissionsResult(permissions, results);
                }
            });
        }

        private boolean requestPermissionsInternal(String[] permissions, WindowAndroid.PermissionCallback callback) {
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            Activity activity = (Activity)ActivityWindowAndroid.this.getActivity().get();
            if (activity == null) {
                return false;
            }
            int requestCode = ActivityWindowAndroid.this.generateNextRequestCode();
            ActivityWindowAndroid.this.mOutstandingPermissionRequests.put(requestCode, (Object)callback);
            activity.requestPermissions(permissions, requestCode);
            return true;
        }
    }
}

