/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import java.io.File;
import java.util.Locale;
import org.chromium.base.ResourceExtractor;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.SuppressFBWarnings;

@JNINamespace(value="ui")
public class ResourceBundle {
    private static ResourceExtractor.ResourceEntry[] sActiveLocaleResources;

    private static String toChromeLocaleName(String srcFileName) {
        String[] parts = (srcFileName = srcFileName.replace(".lpak", ".pak")).split("_");
        if (parts.length > 1) {
            int dotIdx = parts[1].indexOf(46);
            return parts[0] + "-" + parts[1].substring(0, dotIdx).toUpperCase(Locale.ENGLISH) + parts[1].substring(dotIdx);
        }
        return srcFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"LI_LAZY_INIT_UPDATE_STATIC"})
    public static void initializeLocalePaks(Context context, int localePaksResId) {
        ThreadUtils.assertOnUiThread();
        assert (sActiveLocaleResources == null);
        Resources resources = context.getResources();
        TypedArray resIds = resources.obtainTypedArray(localePaksResId);
        try {
            int len = resIds.length();
            sActiveLocaleResources = new ResourceExtractor.ResourceEntry[len];
            for (int i = 0; i < len; ++i) {
                int resId = resIds.getResourceId(i, 0);
                String resPath = resources.getString(resId);
                String srcBaseName = new File(resPath).getName();
                String dstBaseName = ResourceBundle.toChromeLocaleName(srcBaseName);
                ResourceBundle.sActiveLocaleResources[i] = new ResourceExtractor.ResourceEntry(resId, resPath, dstBaseName);
            }
        }
        finally {
            resIds.recycle();
        }
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static ResourceExtractor.ResourceEntry[] getActiveLocaleResources() {
        return sActiveLocaleResources;
    }

    @CalledByNative
    private static String getLocalePakResourcePath(String locale) {
        if (sActiveLocaleResources == null) {
            return null;
        }
        String fileName = locale + ".pak";
        for (ResourceExtractor.ResourceEntry entry : sActiveLocaleResources) {
            if (!fileName.equals(entry.extractedFileName)) continue;
            return entry.pathWithinApk;
        }
        return null;
    }
}

