/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.resources.dynamics;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import org.chromium.ui.resources.dynamics.DynamicResourceLoader;
import org.chromium.ui.resources.dynamics.ViewResourceAdapter;

public class ViewResourceInflater {
    private int mLayoutId;
    private int mViewId;
    private Context mContext;
    private ViewGroup mContainer;
    private DynamicResourceLoader mResourceLoader;
    private ViewResourceAdapter mResourceAdapter;
    private View mView;
    private boolean mNeedsLayoutUpdate;
    private boolean mIsInvalidated;
    private boolean mIsAttached;
    private ViewInflaterOnDrawListener mOnDrawListener;
    private static final int INVALID_ID = -1;

    public ViewResourceInflater(int layoutId, int viewId, Context context, ViewGroup container, DynamicResourceLoader resourceLoader) {
        this.mLayoutId = layoutId;
        this.mViewId = viewId;
        this.mContext = context;
        this.mContainer = container;
        this.mResourceLoader = resourceLoader;
    }

    public void inflate() {
        if (this.mView != null) {
            return;
        }
        this.mView = LayoutInflater.from((Context)this.mContext).inflate(this.mLayoutId, this.mContainer, false);
        assert (this.mView.getId() == this.mViewId);
        this.onFinishInflate();
        this.registerResource();
        this.mNeedsLayoutUpdate = true;
    }

    public void invalidate() {
        this.invalidate(false);
    }

    public void invalidate(boolean didViewSizeChange) {
        if (this.mView == null) {
            this.inflate();
        }
        this.mIsInvalidated = true;
        if (!this.mIsAttached && this.shouldAttachView()) {
            this.attachView();
        }
        if (this.mIsAttached) {
            if (didViewSizeChange || this.mNeedsLayoutUpdate) {
                this.updateLayoutParams();
            }
        } else {
            this.layout();
            this.invalidateResource();
        }
        this.mNeedsLayoutUpdate = false;
    }

    public void destroy() {
        if (this.mView == null) {
            return;
        }
        this.unregisterResource();
        this.detachView();
        this.mView = null;
        this.mLayoutId = -1;
        this.mViewId = -1;
        this.mContext = null;
        this.mContainer = null;
        this.mResourceLoader = null;
    }

    public int getMeasuredWidth() {
        assert (this.mView != null);
        return this.mView.getMeasuredWidth();
    }

    public int getMeasuredHeight() {
        assert (this.mView != null);
        return this.mView.getMeasuredHeight();
    }

    public int getViewId() {
        return this.mViewId;
    }

    protected void onFinishInflate() {
    }

    protected boolean shouldAttachView() {
        return true;
    }

    protected boolean shouldDetachViewAfterCapturing() {
        return true;
    }

    protected int getWidthMeasureSpec() {
        return this.getUnspecifiedMeasureSpec();
    }

    protected int getHeightMeasureSpec() {
        return this.getUnspecifiedMeasureSpec();
    }

    protected void layout() {
        this.mView.measure(this.getWidthMeasureSpec(), this.getHeightMeasureSpec());
        this.mView.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected View getView() {
        return this.mView;
    }

    protected Context getContext() {
        return this.mContext;
    }

    private void attachView() {
        if (!this.mIsAttached) {
            assert (this.mView.getParent() == null);
            this.mContainer.addView(this.mView);
            this.mIsAttached = true;
            if (this.mOnDrawListener == null) {
                this.mOnDrawListener = new ViewInflaterOnDrawListener();
                this.mView.getViewTreeObserver().addOnDrawListener((ViewTreeObserver.OnDrawListener)this.mOnDrawListener);
            }
        }
    }

    private void detachView() {
        if (this.mIsAttached) {
            if (this.mOnDrawListener != null) {
                this.mView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.mOnDrawListener);
                this.mOnDrawListener = null;
            }
            assert (this.mView.getParent() != null);
            this.mContainer.removeView(this.mView);
            this.mIsAttached = false;
        }
    }

    private void updateLayoutParams() {
        assert (this.mView != null);
        int widthMeasureSpec = this.getWidthMeasureSpec();
        int width = -2;
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0x40000000) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        }
        int heightMeasureSpec = this.getHeightMeasureSpec();
        int height = -2;
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        }
        ViewGroup.LayoutParams params = this.mView.getLayoutParams();
        params.width = width;
        params.height = height;
        this.mView.setLayoutParams(params);
    }

    private int getUnspecifiedMeasureSpec() {
        return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    }

    private void registerResource() {
        if (this.mResourceAdapter == null) {
            this.mResourceAdapter = new ViewInflaterAdapter(this.mView.findViewById(this.mViewId));
        }
        if (this.mResourceLoader != null) {
            this.mResourceLoader.registerResource(this.mViewId, this.mResourceAdapter);
        }
    }

    private void unregisterResource() {
        if (this.mResourceLoader != null) {
            this.mResourceLoader.unregisterResource(this.mViewId);
        }
        this.mResourceAdapter = null;
    }

    private void invalidateResource() {
        if (this.mIsInvalidated && this.mView != null && this.mResourceAdapter != null) {
            this.mIsInvalidated = false;
            this.mResourceAdapter.invalidate(null);
        }
    }

    protected void onCaptureEnd() {
        if (this.shouldDetachViewAfterCapturing()) {
            this.detachView();
        }
    }

    private class ViewInflaterOnDrawListener
    implements ViewTreeObserver.OnDrawListener {
        private ViewInflaterOnDrawListener() {
        }

        public void onDraw() {
            ViewResourceInflater.this.invalidateResource();
        }
    }

    private class ViewInflaterAdapter
    extends ViewResourceAdapter {
        public ViewInflaterAdapter(View view) {
            super(view);
        }

        @Override
        protected void onCaptureEnd() {
            ViewResourceInflater.this.onCaptureEnd();
        }
    }
}

