/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.util.ArrayList;
import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;
import org.xwalk.core.XWalkNavigationItem;

public class XWalkNavigationHistory {
    private ArrayList<Object> constructorTypes;
    private ArrayList<Object> constructorParams;
    private ReflectMethod postWrapperMethod;
    private ReflectMethod enumDirectionClassValueOfMethod = new ReflectMethod();
    private XWalkCoreWrapper coreWrapper;
    private Object bridge;
    private ReflectMethod sizeMethod = new ReflectMethod(null, "size", new Class[0]);
    private ReflectMethod hasItemAtintMethod = new ReflectMethod(null, "hasItemAt", new Class[0]);
    private ReflectMethod getItemAtintMethod = new ReflectMethod(null, "getItemAt", new Class[0]);
    private ReflectMethod getCurrentItemMethod = new ReflectMethod(null, "getCurrentItem", new Class[0]);
    private ReflectMethod canGoBackMethod = new ReflectMethod(null, "canGoBack", new Class[0]);
    private ReflectMethod canGoForwardMethod = new ReflectMethod(null, "canGoForward", new Class[0]);
    private ReflectMethod navigateDirectionInternalintMethod = new ReflectMethod(null, "navigate", new Class[0]);
    private ReflectMethod getCurrentIndexMethod = new ReflectMethod(null, "getCurrentIndex", new Class[0]);
    private ReflectMethod clearMethod = new ReflectMethod(null, "clear", new Class[0]);

    private Object ConvertDirection(Direction type2) {
        return this.enumDirectionClassValueOfMethod.invoke(type2.toString());
    }

    protected Object getBridge() {
        return this.bridge;
    }

    public XWalkNavigationHistory(Object bridge) {
        this.bridge = bridge;
        this.reflectionInit();
    }

    public int size() {
        try {
            return (Integer)this.sizeMethod.invoke(new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return 0;
        }
    }

    public boolean hasItemAt(int index) {
        try {
            return (Boolean)this.hasItemAtintMethod.invoke(index);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return false;
        }
    }

    public XWalkNavigationItem getItemAt(int index) {
        try {
            return (XWalkNavigationItem)this.coreWrapper.getWrapperObject(this.getItemAtintMethod.invoke(index));
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return null;
        }
    }

    public XWalkNavigationItem getCurrentItem() {
        try {
            return (XWalkNavigationItem)this.coreWrapper.getWrapperObject(this.getCurrentItemMethod.invoke(new Object[0]));
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return null;
        }
    }

    public boolean canGoBack() {
        try {
            return (Boolean)this.canGoBackMethod.invoke(new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return false;
        }
    }

    public boolean canGoForward() {
        try {
            return (Boolean)this.canGoForwardMethod.invoke(new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return false;
        }
    }

    public void navigate(Direction direction, int steps) {
        try {
            this.navigateDirectionInternalintMethod.invoke(this.ConvertDirection(direction), steps);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public int getCurrentIndex() {
        try {
            return (Integer)this.getCurrentIndexMethod.invoke(new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return 0;
        }
    }

    public void clear() {
        try {
            this.clearMethod.invoke(new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    void reflectionInit() {
        XWalkCoreWrapper.initEmbeddedMode();
        this.coreWrapper = XWalkCoreWrapper.getInstance();
        if (this.coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectObject(this);
            return;
        }
        this.enumDirectionClassValueOfMethod.init(null, this.coreWrapper.getBridgeClass("XWalkNavigationHistoryInternal$DirectionInternal"), "valueOf", String.class);
        this.sizeMethod.init(this.bridge, null, "sizeSuper", new Class[0]);
        this.hasItemAtintMethod.init(this.bridge, null, "hasItemAtSuper", Integer.TYPE);
        this.getItemAtintMethod.init(this.bridge, null, "getItemAtSuper", Integer.TYPE);
        this.getCurrentItemMethod.init(this.bridge, null, "getCurrentItemSuper", new Class[0]);
        this.canGoBackMethod.init(this.bridge, null, "canGoBackSuper", new Class[0]);
        this.canGoForwardMethod.init(this.bridge, null, "canGoForwardSuper", new Class[0]);
        this.navigateDirectionInternalintMethod.init(this.bridge, null, "navigateSuper", this.coreWrapper.getBridgeClass("XWalkNavigationHistoryInternal$DirectionInternal"), Integer.TYPE);
        this.getCurrentIndexMethod.init(this.bridge, null, "getCurrentIndexSuper", new Class[0]);
        this.clearMethod.init(this.bridge, null, "clearSuper", new Class[0]);
    }

    public static enum Direction {
        BACKWARD,
        FORWARD;

    }
}

