/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import java.io.File;
import java.util.List;
import org.xwalk.core.R;
import org.xwalk.core.XWalkDecompressor;
import org.xwalk.core.XWalkDialogManager;
import org.xwalk.core.XWalkEnvironment;
import org.xwalk.core.XWalkLibraryLoader;

public class XWalkUpdater {
    private static final String ANDROID_MARKET_DETAILS = "market://details?id=";
    private static final String GOOGLE_PLAY_PACKAGE = "com.android.vending";
    private static final String TAG = "XWalkLib";
    private XWalkUpdateListener mUpdateListener;
    private XWalkBackgroundUpdateListener mBackgroundUpdateListener;
    private Context mContext;
    private XWalkDialogManager mDialogManager;
    private Runnable mDownloadCommand;
    private Runnable mCancelCommand;

    public XWalkUpdater(XWalkUpdateListener listener, Context context) {
        this.mUpdateListener = listener;
        this.mContext = context;
        this.mDialogManager = new XWalkDialogManager(context);
    }

    public XWalkUpdater(XWalkUpdateListener listener, Context context, XWalkDialogManager dialogManager) {
        this.mUpdateListener = listener;
        this.mContext = context;
        this.mDialogManager = dialogManager;
    }

    public XWalkUpdater(XWalkBackgroundUpdateListener listener, Context context) {
        this.mBackgroundUpdateListener = listener;
        this.mContext = context;
    }

    public boolean updateXWalkRuntime() {
        if (XWalkLibraryLoader.isInitializing() || XWalkLibraryLoader.isDownloading()) {
            Log.d((String)TAG, (String)"Other initialization or download is proceeding");
            return false;
        }
        if (XWalkLibraryLoader.isLibraryReady()) {
            Log.d((String)TAG, (String)"Initialization has been completed. Do not need to update");
            return false;
        }
        int status = XWalkLibraryLoader.getLibraryStatus();
        if (status == 0) {
            throw new RuntimeException("Must invoke XWalkInitializer.initAsync() first");
        }
        if (this.mUpdateListener != null) {
            this.mDownloadCommand = new Runnable(){

                @Override
                public void run() {
                    XWalkUpdater.this.downloadXWalkApk();
                }
            };
            this.mCancelCommand = new Runnable(){

                @Override
                public void run() {
                    Log.d((String)XWalkUpdater.TAG, (String)"XWalkUpdater cancelled");
                    XWalkUpdater.this.mUpdateListener.onXWalkUpdateCancelled();
                }
            };
            this.mDialogManager.showInitializationError(status, this.mCancelCommand, this.mDownloadCommand);
        } else if (this.mBackgroundUpdateListener != null) {
            String url = XWalkEnvironment.getXWalkApkUrl();
            XWalkLibraryLoader.startHttpDownload(new BackgroundListener(), this.mContext, url);
        } else {
            throw new IllegalArgumentException("Update listener is null");
        }
        return true;
    }

    public boolean dismissDialog() {
        if (this.mDialogManager == null || !this.mDialogManager.isShowingDialog()) {
            return false;
        }
        this.mDialogManager.dismissDialog();
        return true;
    }

    public void setXWalkApkUrl(String url) {
        XWalkEnvironment.setXWalkApkUrl(url);
    }

    public boolean cancelBackgroundDownload() {
        return XWalkLibraryLoader.cancelHttpDownload();
    }

    private void downloadXWalkApk() {
        String url = XWalkEnvironment.getXWalkApkUrl();
        if (!url.isEmpty()) {
            XWalkLibraryLoader.startDownloadManager(new ForegroundListener(), this.mContext, url);
            return;
        }
        String packageName = "org.xwalk.core";
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)(ANDROID_MARKET_DETAILS + packageName)));
        List infos = this.mContext.getPackageManager().queryIntentActivities(intent, 131072);
        StringBuilder supportedStores = new StringBuilder();
        boolean hasGooglePlay = false;
        Log.d((String)TAG, (String)"Available Stores:");
        for (ResolveInfo info : infos) {
            Log.d((String)TAG, (String)info.activityInfo.packageName);
            hasGooglePlay |= info.activityInfo.packageName.equals(GOOGLE_PLAY_PACKAGE);
            String storeName = this.getStoreName(info.activityInfo.packageName);
            if (storeName == null) continue;
            if (supportedStores.length() > 0) {
                supportedStores.append("/");
            }
            supportedStores.append(storeName);
        }
        if (supportedStores.length() == 0) {
            this.mDialogManager.showUnsupportedStore(this.mCancelCommand);
            return;
        }
        packageName = hasGooglePlay || !XWalkEnvironment.isIaDevice() ? (XWalkEnvironment.is64bitApp() ? "org.xwalk.core64" : "org.xwalk.core") : (XWalkEnvironment.is64bitApp() ? "org.xwalk.core64.ia" : "org.xwalk.core.ia");
        Log.d((String)TAG, (String)("Package name of Crosswalk to download: " + packageName));
        intent.setData(Uri.parse((String)(ANDROID_MARKET_DETAILS + packageName)));
        final Intent storeIntent = intent;
        String storeName = hasGooglePlay ? this.getStoreName(GOOGLE_PLAY_PACKAGE) : supportedStores.toString();
        Log.d((String)TAG, (String)("Supported Stores: " + storeName));
        this.mDialogManager.showSelectStore(new Runnable(){

            @Override
            public void run() {
                try {
                    XWalkUpdater.this.mContext.startActivity(storeIntent);
                }
                catch (ActivityNotFoundException e) {
                    XWalkUpdater.this.mDialogManager.showUnsupportedStore(XWalkUpdater.this.mCancelCommand);
                }
            }
        }, storeName);
    }

    private boolean verifyDownloadedXWalkRuntime(String libFile) {
        PackageInfo runtimePkgInfo = this.mContext.getPackageManager().getPackageArchiveInfo(libFile, 64);
        if (runtimePkgInfo == null) {
            Log.e((String)TAG, (String)"The downloaded XWalkRuntimeLib.apk is invalid!");
            return false;
        }
        PackageInfo appPkgInfo = null;
        try {
            appPkgInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (runtimePkgInfo.signatures == null || appPkgInfo.signatures == null) {
            Log.e((String)TAG, (String)"No signature in package info");
            return false;
        }
        if (runtimePkgInfo.signatures.length != appPkgInfo.signatures.length) {
            Log.e((String)TAG, (String)"signatures length not equal");
            return false;
        }
        for (int i = 0; i < runtimePkgInfo.signatures.length; ++i) {
            Log.d((String)TAG, (String)("Checking signature " + i));
            if (appPkgInfo.signatures[i].equals((Object)runtimePkgInfo.signatures[i])) continue;
            Log.e((String)TAG, (String)"signatures do not match");
            return false;
        }
        Log.d((String)TAG, (String)"Signature check passed");
        return true;
    }

    private String getStoreName(String storePackage) {
        if (storePackage.equals(GOOGLE_PLAY_PACKAGE)) {
            return this.mContext.getString(R.string.google_play_store);
        }
        return null;
    }

    private class BackgroundListener
    implements XWalkLibraryLoader.DownloadListener {
        private BackgroundListener() {
        }

        @Override
        public void onDownloadStarted() {
            XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateStarted();
        }

        @Override
        public void onDownloadUpdated(int percentage) {
            XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateProgress(percentage);
        }

        @Override
        public void onDownloadCancelled() {
            XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateCancelled();
        }

        @Override
        public void onDownloadFailed(int status, int error) {
            XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateFailed();
        }

        @Override
        public void onDownloadCompleted(Uri uri) {
            final String libFile = uri.getPath();
            final String destDir = XWalkEnvironment.getExtractedCoreDir();
            Log.d((String)XWalkUpdater.TAG, (String)("Download mode extract dir: " + destDir));
            new AsyncTask<Void, Void, Boolean>(){

                protected Boolean doInBackground(Void ... params) {
                    if (XWalkEnvironment.isXWalkVerify() && !XWalkUpdater.this.verifyDownloadedXWalkRuntime(libFile)) {
                        return false;
                    }
                    if (XWalkDecompressor.isResourceCompressed(libFile) ? !XWalkDecompressor.decompressResource(libFile, destDir) : !XWalkDecompressor.extractResource(libFile, destDir)) {
                        return false;
                    }
                    return true;
                }

                protected void onPostExecute(Boolean result) {
                    new File(libFile).delete();
                    if (!result.booleanValue()) {
                        XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateFailed();
                    } else {
                        XWalkUpdater.this.mBackgroundUpdateListener.onXWalkUpdateCompleted();
                    }
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private class ForegroundListener
    implements XWalkLibraryLoader.DownloadListener {
        private ForegroundListener() {
        }

        @Override
        public void onDownloadStarted() {
            XWalkUpdater.this.mDialogManager.showDownloadProgress(new Runnable(){

                @Override
                public void run() {
                    XWalkLibraryLoader.cancelDownloadManager();
                }
            });
        }

        @Override
        public void onDownloadUpdated(int percentage) {
            XWalkUpdater.this.mDialogManager.setProgress(percentage, 100);
        }

        @Override
        public void onDownloadCancelled() {
            XWalkUpdater.this.mUpdateListener.onXWalkUpdateCancelled();
        }

        @Override
        public void onDownloadFailed(int status, int error) {
            XWalkUpdater.this.mDialogManager.dismissDialog();
            XWalkUpdater.this.mDialogManager.showDownloadError(XWalkUpdater.this.mCancelCommand, XWalkUpdater.this.mDownloadCommand);
        }

        @Override
        public void onDownloadCompleted(Uri uri) {
            XWalkUpdater.this.mDialogManager.dismissDialog();
            Log.d((String)XWalkUpdater.TAG, (String)("Install the Crosswalk runtime: " + uri.toString()));
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x10000000);
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            XWalkUpdater.this.mContext.startActivity(intent);
        }
    }

    public static interface XWalkBackgroundUpdateListener {
        public void onXWalkUpdateStarted();

        public void onXWalkUpdateProgress(int var1);

        public void onXWalkUpdateCancelled();

        public void onXWalkUpdateFailed();

        public void onXWalkUpdateCompleted();
    }

    public static interface XWalkUpdateListener {
        public void onXWalkUpdateCancelled();
    }
}

