/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.extension.BindingObject;
import org.xwalk.core.extension.MessageInfo;

public class EventTarget
extends BindingObject {
    private String TAG = "EventTarget";
    private Map<String, MessageInfo> mEvents = new HashMap<String, MessageInfo>();

    public EventTarget() {
        this.mHandler.register("addEventListener", this);
        this.mHandler.register("removeEventListener", this);
    }

    public void startEvent(String type2) {
    }

    public void stopEvent(String type2) {
    }

    public boolean isEventActive(String type2) {
        return this.mEvents.containsKey(type2);
    }

    public void dispatchEvent(String type2) {
        this.dispatchEvent(type2, null);
    }

    public void dispatchEvent(String type2, JSONObject data) {
        try {
            if (!this.mEvents.containsKey(type2)) {
                Log.w((String)this.TAG, (String)("Attempt to dispatch to non-existing event :" + type2));
                return;
            }
            MessageInfo info = this.mEvents.get(type2);
            JSONArray args = new JSONArray();
            if (data != null) {
                args.put(0, (Object)data);
            }
            info.postResult(args);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    public void onAddEventListener(MessageInfo info) {
        try {
            String type2 = info.getArgs().getString(0);
            if (this.mEvents.containsKey(type2)) {
                Log.w((String)this.TAG, (String)("Trying to re-add the event :" + type2));
                return;
            }
            this.mEvents.put(type2, info);
            this.startEvent(type2);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }

    public void onRemoveEventListener(MessageInfo info) {
        try {
            String type2 = info.getArgs().getString(0);
            if (!this.mEvents.containsKey(type2)) {
                Log.w((String)this.TAG, (String)("Attempt to remove non-existing event :" + type2));
                return;
            }
            this.stopEvent(type2);
            this.mEvents.remove(type2);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
    }
}

