/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwalk.core.XWalkExternalExtensionManager;
import org.xwalk.core.XWalkNativeExtensionLoader;
import org.xwalk.core.XWalkView;
import org.xwalk.core.extension.XWalkExtensionContextClient;
import org.xwalk.core.extension.XWalkExternalExtension;
import org.xwalk.core.extension.XWalkExternalExtensionBridge;
import org.xwalk.core.extension.XWalkExternalExtensionBridgeFactory;

public class XWalkExternalExtensionManagerImpl
extends XWalkExternalExtensionManager
implements XWalkExtensionContextClient {
    private static final String TAG = "XWalkExternalExtensionManagerImpl";
    private final XWalkView mXWalkView;
    private final Context mContext;
    private final HashMap<String, XWalkExternalExtensionBridge> mExtensions = new HashMap();
    private boolean mLoadExternalExtensions;
    private final XWalkNativeExtensionLoader mNativeExtensionLoader;

    public XWalkExternalExtensionManagerImpl(XWalkView view) {
        super(view);
        this.mXWalkView = view;
        if (this.getBridge() == null) {
            Log.e((String)TAG, (String)"Cannot load external extensions due to old version of runtime library");
            this.mContext = null;
            this.mLoadExternalExtensions = false;
            this.mNativeExtensionLoader = null;
            return;
        }
        this.mContext = this.getViewContext();
        this.mLoadExternalExtensions = true;
        this.mNativeExtensionLoader = new XWalkNativeExtensionLoader();
        this.loadNativeExtensions();
    }

    @Override
    public void registerExtension(XWalkExternalExtension extension) {
        if (this.mExtensions.get(extension.getExtensionName()) != null) {
            Log.e((String)TAG, (String)(extension.getExtensionName() + "is already registered!"));
            return;
        }
        XWalkExternalExtensionBridge bridge = XWalkExternalExtensionBridgeFactory.createInstance(extension);
        this.mExtensions.put(extension.getExtensionName(), bridge);
    }

    @Override
    public void unregisterExtension(String name) {
        XWalkExternalExtensionBridge bridge = this.mExtensions.get(name);
        if (bridge != null) {
            this.mExtensions.remove(name);
            bridge.onDestroy();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Activity getActivity() {
        if (this.mContext instanceof Activity) {
            return (Activity)this.mContext;
        }
        return null;
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        throw new ActivityNotFoundException("This method is no longer supported");
    }

    @Override
    public void loadExtension(String extensionPath) {
        String jsonFileContent;
        if (!this.mLoadExternalExtensions) {
            return;
        }
        int len = extensionPath.length();
        if (extensionPath.charAt(len - 1) == File.separatorChar) {
            extensionPath = extensionPath.substring(0, len - 1);
        }
        String folderName = extensionPath.substring(extensionPath.lastIndexOf(File.separatorChar) + 1);
        String jsonFile = extensionPath + File.separator + folderName + ".json";
        try {
            jsonFileContent = this.getFileContent(this.mContext, jsonFile, false);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Failed to read json file: " + jsonFile));
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonFileContent);
            String name = jsonObject.getString("name");
            String className = jsonObject.getString("class");
            String jsApiFile = jsonObject.optString("jsapi");
            if (jsApiFile != null && jsApiFile.length() != 0) {
                jsApiFile = extensionPath + File.separator + jsApiFile;
            }
            String jsApi = null;
            if (jsApiFile != null && jsApiFile.length() != 0) {
                try {
                    jsApi = this.getFileContent(this.mContext, jsApiFile, false);
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)("Failed to read the file " + jsApiFile));
                    return;
                }
            }
            if (name != null && className != null) {
                Log.i((String)TAG, (String)("createExternalExtension: name: " + name + " className: " + className));
                this.createExternalExtension(name, className, jsApi, this);
            }
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)("Failed to parse json file: " + jsonFile));
        }
    }

    @Override
    public void postMessage(XWalkExternalExtension extension, int instanceID, String message) {
        XWalkExternalExtensionBridge bridge = this.mExtensions.get(extension.getExtensionName());
        if (bridge != null) {
            bridge.postMessage(instanceID, message);
        }
    }

    @Override
    public void postBinaryMessage(XWalkExternalExtension extension, int instanceID, byte[] message) {
        XWalkExternalExtensionBridge bridge = this.mExtensions.get(extension.getExtensionName());
        if (bridge != null) {
            bridge.postBinaryMessage(instanceID, message);
        }
    }

    @Override
    public void broadcastMessage(XWalkExternalExtension extension, String message) {
        XWalkExternalExtensionBridge bridge = this.mExtensions.get(extension.getExtensionName());
        if (bridge != null) {
            bridge.broadcastMessage(message);
        }
    }

    @Override
    public void onStart() {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onStart();
        }
    }

    @Override
    public void onResume() {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onResume();
        }
    }

    @Override
    public void onPause() {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onPause();
        }
    }

    @Override
    public void onStop() {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onStop();
        }
    }

    @Override
    public void onDestroy() {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onDestroy();
        }
        this.mExtensions.clear();
    }

    @Override
    public void onNewIntent(Intent intent) {
        for (XWalkExternalExtensionBridge extension : this.mExtensions.values()) {
            extension.onNewIntent(intent);
        }
    }

    public void setAllowExternalExtensions(boolean load) {
        this.mLoadExternalExtensions = load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(Context context, String fileName, boolean fromRaw) throws IOException {
        String result = "";
        try (InputStream inputStream = null;){
            String resName;
            Resources resource;
            int resId;
            if (fromRaw && (resId = (resource = context.getResources()).getIdentifier(resName = new File(fileName).getName().split("\\.")[0], "raw", context.getPackageName())) > 0) {
                try {
                    inputStream = resource.openRawResource(resId);
                }
                catch (Resources.NotFoundException e) {
                    Log.w((String)TAG, (String)("Inputstream failed to open for R.raw." + resName + ", try to find it in assets"));
                }
            }
            if (inputStream == null) {
                AssetManager assetManager = context.getAssets();
                inputStream = assetManager.open(fileName);
            }
            int size = inputStream.available();
            byte[] buffer = new byte[size];
            inputStream.read(buffer);
            result = new String(buffer);
        }
        return result;
    }

    private void createExternalExtension(String name, String className, String jsApi, XWalkExtensionContextClient extensionContext) {
        Context context = extensionContext.getContext();
        try {
            Class<?> clazz = context.getClassLoader().loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, XWalkExtensionContextClient.class);
            constructor.newInstance(name, jsApi, this);
        }
        catch (ClassNotFoundException e) {
            XWalkExternalExtensionManagerImpl.handleException(e);
        }
        catch (IllegalAccessException e) {
            XWalkExternalExtensionManagerImpl.handleException(e);
        }
        catch (InstantiationException e) {
            XWalkExternalExtensionManagerImpl.handleException(e);
        }
        catch (InvocationTargetException e) {
            XWalkExternalExtensionManagerImpl.handleException(e);
        }
        catch (NoSuchMethodException e) {
            XWalkExternalExtensionManagerImpl.handleException(e);
        }
    }

    private void loadNativeExtensions() {
        String path = null;
        try {
            ApplicationInfo appInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 0);
            path = appInfo.nativeLibraryDir;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (path != null && new File(path).isDirectory()) {
            this.mNativeExtensionLoader.registerNativeExtensionsInPath(path);
        }
    }

    private static void handleException(Exception e) {
        Log.e((String)TAG, (String)("Error in calling methods of external extensions. " + e.toString()));
        e.printStackTrace();
    }
}

