/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal.extension.api.presentation;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import java.lang.ref.WeakReference;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;

public class XWalkPresentationContent {
    public final int INVALID_PRESENTATION_ID = -1;
    private int mPresentationId = -1;
    private XWalkViewInternal mContentView;
    private Context mContext;
    private WeakReference<Activity> mActivity;
    private PresentationDelegate mDelegate;

    public XWalkPresentationContent(Context context, WeakReference<Activity> activity, PresentationDelegate delegate) {
        this.mContext = context;
        this.mActivity = activity;
        this.mDelegate = delegate;
    }

    public void load(String url) {
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mContentView == null) {
            this.mContentView = new XWalkViewInternal(this.mContext, activity);
            XWalkUIClientInternal xWalkUIClient = new XWalkUIClientInternal(this.mContentView){

                @Override
                public void onJavascriptCloseWindow(XWalkViewInternal view) {
                    XWalkPresentationContent.this.mPresentationId = -1;
                    XWalkPresentationContent.this.onContentClosed();
                }

                @Override
                public void onPageLoadStarted(XWalkViewInternal view, String url) {
                    XWalkPresentationContent.this.mPresentationId = XWalkPresentationContent.this.mContentView.getContentID();
                    String script = "navigator.presentation.session = new navigator.presentation.PresentationSession(";
                    script = script + XWalkPresentationContent.this.mPresentationId;
                    script = script + ");";
                    view.evaluateJavascript(script, null);
                }

                @Override
                public void onPageLoadStopped(XWalkViewInternal view, String url, XWalkUIClientInternal.LoadStatusInternal status) {
                    if (status == XWalkUIClientInternal.LoadStatusInternal.FINISHED) {
                        XWalkPresentationContent.this.onContentLoaded();
                    }
                }
            };
            this.mContentView.setUIClient(xWalkUIClient);
        }
        this.mContentView.loadUrl(url);
    }

    public int getPresentationId() {
        return this.mPresentationId;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void close() {
        this.mContentView.onDestroy();
        this.mPresentationId = -1;
        this.mContentView = null;
    }

    public void onPause() {
        this.mContentView.pauseTimers();
        this.mContentView.onHide();
    }

    public void onResume() {
        this.mContentView.resumeTimers();
        this.mContentView.onShow();
    }

    private void onContentLoaded() {
        if (this.mDelegate != null) {
            this.mDelegate.onContentLoaded(this);
        }
    }

    private void onContentClosed() {
        if (this.mDelegate != null) {
            this.mDelegate.onContentClosed(this);
        }
    }

    public static interface PresentationDelegate {
        public void onContentLoaded(XWalkPresentationContent var1);

        public void onContentClosed(XWalkPresentationContent var1);
    }
}

