package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONObject;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

/**
 * ACMSからのJSONがbooleanのresultという項目を予め持っているクラスです。booleanのresultを持つJSONに対応するクラスを作成するときはこのクラスを継承してください。
 *
 */
public class LogSendFlagJSON extends AcmsCommonJSON {
	public static final String JSONPropertyResult = "logSendFlg";
	public int logSendFlg;

	public LogSendFlagJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		super.parse(json);
        logSendFlg = getInt(json, JSONPropertyResult, 0);
	}
}
