package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.adf.util.DateTimeUtil;

public class RoomListJSON extends AcmsCommonJSON {
    private static final String Body = "body";
    private static final String ChatRoomInfoList = "chatRoomInfoList";
    private static final String InsertDate = "insertDate";
    private static final String Time = "time";
    private static final String RoomId = "roomId";
    private static final String RoomName = "roomName";
    private static final String RoomType = "roomType";

    private static final String LastMessageInfo = "lastMessageInfo";
    private static final String Message = "message";
    private static final String MessageId = "messageId";
    private static final String ShopMemberId = "shopMemberId";
    private static final String MessageType = "messageType";
    private static final String UnreadCount = "unreadCount";
    private static final String AttendUsers = "attendUsers";

    public ArrayList<ChatRoomDto> roomList;

    public RoomListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(Body)) { return; }

        JSONArray roomListJsonArray = json.getJSONObject(Body).getJSONArray(ChatRoomInfoList);
        if (roomListJsonArray == null) { return; }

        roomList = new ArrayList<ChatRoomDto>();
        for (int listCount = 0; listCount < roomListJsonArray.length(); listCount++) {
            if (roomListJsonArray.getJSONObject(listCount).length() == 0) {
                break;
            }
            ChatRoomDto chatRoomDto = new ChatRoomDto();
            ChatMessageDto chatMessageDto = new ChatMessageDto();

            chatRoomDto.chatRoomId = roomListJsonArray.getJSONObject(listCount).getInt(RoomId);
            chatRoomDto.chatRoomName = roomListJsonArray.getJSONObject(listCount).getString(RoomName);
            chatRoomDto.type = roomListJsonArray.getJSONObject(listCount).getInt(RoomType);
            chatRoomDto.unreadCount =  roomListJsonArray.getJSONObject(listCount).has(UnreadCount) ? roomListJsonArray.getJSONObject(listCount).getInt(UnreadCount) : 0;
            chatRoomDto.userCount = roomListJsonArray.getJSONObject(listCount).getJSONArray(AttendUsers).length();

            //最後メッセージ情報がある場合の処理
            JSONObject lastMessageInfoJSON = roomListJsonArray.getJSONObject(listCount).has(LastMessageInfo) ? roomListJsonArray.getJSONObject(listCount).getJSONObject(LastMessageInfo) : null;
            if (lastMessageInfoJSON != null && lastMessageInfoJSON.has(MessageId)) {
                chatMessageDto.chatRoomId = chatRoomDto.chatRoomId;
                chatMessageDto.message = lastMessageInfoJSON.getString(Message);
                chatMessageDto.messageType = lastMessageInfoJSON.getInt(MessageType);
                if (lastMessageInfoJSON.has(InsertDate)) {
                    chatMessageDto.insertDate = DateTimeUtil.millToDateString(lastMessageInfoJSON.getJSONObject(InsertDate).getLong(Time));
                }
                chatMessageDto.shopMemberId = lastMessageInfoJSON.getInt(ShopMemberId);
                chatMessageDto.chatMessageId = lastMessageInfoJSON.getInt(MessageId);
                chatRoomDto.lastMessageInfo = chatMessageDto;
            }
            roomList.add(chatRoomDto);
        }
    }
}

