package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.CollaborationDto;

public class ArchiveDao extends AbstractDao {

	/**
	 * {@link ArchiveDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ArchiveDao() {
	}

	@Override
	protected ArchiveDto convert(Cursor cursor) {
		ArchiveDto dto = new ArchiveDto();

		int column = cursor.getColumnIndex("archive_id");
		if (column != -1) {
			dto.archiveId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("archive_name");
		if (column != -1) {
			dto.archiveName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("archive_type");
		if (column != -1) {
			dto.archiveType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("archive_url");
		if (column != -1) {
			dto.archiveUrl = cursor.getString(column);
		}
		column = cursor.getColumnIndex("collaboration_id");
		if (column != -1) {
			dto.collaborationId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("shop_member_id");
		if (column != -1) {
			dto.shopMemberId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("archive_save_path");
		if (column != -1) {
			dto.archiveSavePath = cursor.getString(column);
		}

		return dto;
	}

	public List<ArchiveDto> getArchive(int archiveId) {
		List<ArchiveDto> list = rawQueryGetDtoList("select * from t_archive where archive_id = ?", new String[]{""+ archiveId}, ArchiveDto.class);
		return list;
	}

	public void insertArchive(ArchiveDto dto) {
		insert("insert into t_archive (archive_id, archive_name, archive_type, archive_url, collaboration_id, shop_member_id, archive_save_path) values (?,?)", dto.getInsertValues());
	}

	public boolean updateArchive(ArchiveDto dto) {
		long count = update("update t_archive set archive_name=?, archive_type=?, archive_url=?, collaboration_id=?, shop_member_id=?, archive_save_path=? where archive_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void deleteArchive() {
		try {
			beginTransaction();
			delete("t_archive", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteArchive failed.", e);
			throw new RuntimeException(e);
		}
	}

}
