package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;

public class ChatMessageDao extends AbstractDao {

	/**
	 * {@link ChatMessageDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ChatMessageDao() {
	}

	@Override
	protected ChatMessageDto convert(Cursor cursor) {
		ChatMessageDto dto = new ChatMessageDto();

		int column = cursor.getColumnIndex("chat_message_id");
		if (column != -1) {
			dto.chatMessageId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("chat_room_id");
		if (column != -1) {
			dto.chatRoomId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("shop_member_id");
		if (column != -1) {
			dto.shopMemberId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("message");
		if (column != -1) {
			dto.message = cursor.getString(column);
		}
		column = cursor.getColumnIndex("message_type");
		if (column != -1) {
			dto.messageType = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("image_name");
		if (column != -1) {
			dto.imageName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("download_file_name");
		if (column != -1) {
			dto.downloadFileName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("save_path");
		if (column != -1) {
			dto.savePath = cursor.getString(column);
		}
		column = cursor.getColumnIndex("insert_date");
		if (column != -1) {
			dto.savePath = cursor.getString(column);
		}
		return dto;
	}

	public List<ChatMessageDto> getChatMessage(int chatRoomId) {
		List<ChatMessageDto> list = rawQueryGetDtoList("select * from t_chat_message where chat_room_id = ?", new String[]{""+ chatRoomId}, ChatMessageDto.class);
		return list;
	}

	public void insertChatMessage(ChatMessageDto dto) {
		insert("insert into t_chat_message (chat_message_id, chat_room_id, shop_member_id, message, message_type, image_name, download_file_name, save_path, insert_date) values (?,?,?,?,?,?,?,?,?)", dto.getInsertValues());
	}

	public void insertChatMessage(List<ChatMessageDto> chatMessageDtoList) {
		try {
			beginTransaction();
			for (ChatMessageDto chatMessageDto : chatMessageDtoList) {
				insertChatMessage(chatMessageDto);
			}
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("insertChatRoomList failed.", e);
			throw new RuntimeException(e);
		}
	}

	public boolean updateChatMessage(ChatMessageDto dto) {
		long count = update("update t_chat_message set chat_room_id=?, shop_member_id=?, message=?, message_type=?, image_name=?, download_file_name=?, save_path=?, insert_date=? where chat_message_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void deleteChatMessage() {
		try {
			beginTransaction();
			delete("t_chat_message", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteChatMessage failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}

}
