package jp.agentec.abook.abv.bl.data.dao;

import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.MemberInfoDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

public class ShopMemberDao extends AbstractDao {

	/**
	 * {@link ShopMemberDao} のインスタンスを初期化します。
	 * アンドロイドの android.content.Context のインスタンス
	 * @throws ClassCastException 引数のcontextが android.content.Context 又は、その継承クラスではありません。
	 * @since 1.0.0
	 */
	/*package*/ ShopMemberDao() {
	}

	@Override
	protected ShopMemberDto convert(Cursor cursor) {
		ShopMemberDto dto = new ShopMemberDto();

		int column = cursor.getColumnIndex("shop_member_id");
		if (column != -1) {
			dto.shopMemberId = cursor.getInt(column);
		}
		column = cursor.getColumnIndex("shop_member_name");
		if (column != -1) {
			dto.shopMemberName = cursor.getString(column);
		}
		column = cursor.getColumnIndex("profile_url");
		if (column != -1) {
			dto.profileUrl = cursor.getString(column);
		}
		column = cursor.getColumnIndex("favorite_register_date");
		if (column != -1) {
			dto.favoriteRegisterDate = cursor.getString(column);
		}
		return dto;
	}

	public List<ShopMemberDto> getAllShopMember() {
		List<ShopMemberDto> list = rawQueryGetDtoList("select * from m_shop_member", null, ShopMemberDto.class);
		return list;
	}

	public ShopMemberDto getShopMember(int shopMemberId) {
		return rawQueryGetDto("select * from m_shop_member where shop_member_id=?", new String[]{""+ shopMemberId}, ShopMemberDto.class);
	}
	public void insertShopMember(ShopMemberDto dto) {
		insert("insert into m_shop_member (shop_member_id, shop_member_name, profile_url, favorite_register_date) values (?,?,?,?)", dto.getInsertValues());
	}

	public boolean updateShopMember(MemberInfoDto dto) {
		long count = update("update m_shop_member set shop_member_name=?, profile_url=?, favorite_register_date=? where shop_member_id=?", dto.getUpdateValues());
		return count > 0;
	}

	public void deleteShopMember() {
		try {
			beginTransaction();
			delete("m_shop_member", null, null);
			commit();
		} catch (Exception e) {
			rollback();
			Logger.e("deleteShopMember failed.", e);
			throw new RuntimeException(e);
		} finally {
		}
	}

}
