package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.dto.WorkerGroupDto;

/**
 * Created by leej on 2018/08/28.
 */

public class WorkerGroupDao extends AbstractDao {

    private static final String TAG = "WorkerGroupDao";

    /*package*/ WorkerGroupDao() {
    }

    @Override
    protected WorkerGroupDto convert(Cursor cursor) {
        WorkerGroupDto dto = new WorkerGroupDto();

        int column = cursor.getColumnIndex("group_id");
        if (column != -1) {
            dto.groupId = cursor.getInt(column);
        }
        column = cursor.getColumnIndex("group_name");
        if (column != -1) {
            dto.groupName = cursor.getString(column);
        }

        return dto;
    }

    public List<WorkerGroupDto> getAllWorkerGroup() {
        return rawQueryGetDtoList("select * from m_worker_group order by group_id", null, WorkerGroupDto.class);
    }

    public WorkerGroupDto getWorkerGroup(int groupId) {
        String[] args = new String[] { "" + groupId };
        return rawQueryGetDto("select * from m_worker_group where schedule_id=?", args, WorkerGroupDto.class);
    }

    public void insert(WorkerGroupDto dto) {
        insert("insert into m_worker_group "
                        + "(group_id, "
                        + "group_name) "
                        + "values "
                        + "(?,?)",
                dto.getInsertValues());
    }

    public boolean update(WorkerGroupDto dto) {
        long count = update("update m_worker_group "
                        + "set "
                        + "group_name=? "
                        + "where group_id=?",
                dto.getUpdateValues());
        return count > 0;
    }

    /**
     * 作業グループ削除
     * @param dto
     */
    public void delete(WorkerGroupDto dto) {
        delete("r_task_worker_group", "group_id=?", dto.getKeyValues());
        delete("m_worker_group", "group_id=?", dto.getKeyValues());
    }

    /**
     * グループIDで削除
     * @param groupId
     * @return
     */
    public void deleteById(Integer groupId) {
        String[] keyValue = new String[]{""+ groupId};
        delete("r_task_worker_group", "group_id=?", keyValue);
        delete("m_worker_group", "group_id=?", keyValue);
    }

    public void deleteAll() {
        delete("m_worker_group", null, null);
    }

    /**
     * グループIDで存在チェック
     * @param groupId
     * @return
     */
    public boolean isExist(Integer groupId) {
        return rawQueryGetInt("select COUNT(*) from m_worker_group where group_id=?", new String[]{"" + groupId }) > 0;
    }

    /**
     * 全てのグループID取得
     * @return
     */
    public List<Integer> getAllWorkerGroupId() {
        return rawQueryGetIntegerList("select group_id from m_worker_group order by group_id", null);
    }
}