package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by kim jinsung on 2018/09/17.
 */

public class TPushMessage extends SQLiteTableScript {
    public TPushMessage() {
        super();
    }
    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_push_message ( ");
        sql.append("        push_message_id BIGINT NOT NULL ");
        sql.append("      , operation_id BIGINT NOT NULL ");
        sql.append("      , push_send_login_id VARCHAR(128) ");
        sql.append("      , push_send_date DATE NOT NULL ");
        sql.append("      , push_message TEXT ");
        sql.append("      , reading_flg BOOLEAN NOT NULL DEFAULT 0 ");
        sql.append("      , room_id BIGINT ");
        sql.append("      , room_name VARCHAR(128) ");
        sql.append("      , PRIMARY KEY (push_message_id) ");
/**
 * チャットのプッシュメッセージではoperation_idを使わないため外部キー制約はコメントアウト*/
//        sql.append("      , FOREIGN KEY (operation_id) REFERENCES t_operation (operation_id) ");
        sql.append(" ) ");
        ddl.add(sql.toString());

        return ddl;
    }

    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        return null;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }
}
