package jp.agentec.abook.abv.bl.logic;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import jdk.nashorn.internal.parser.JSONParser;
import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.DownloadedContentInfoJSON;
import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.client.parameters.AcmsContentCheckParameters;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.ContentFileUtil;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.ChatMessageDao;
import jp.agentec.abook.abv.bl.data.dao.ChatRoomDao;
import jp.agentec.abook.abv.bl.data.dao.ContentCategoryDao;
import jp.agentec.abook.abv.bl.data.dao.ContentDao;
import jp.agentec.abook.abv.bl.data.dao.ContentGroupDao;
import jp.agentec.abook.abv.bl.data.dao.ContentMarkingDao;
import jp.agentec.abook.abv.bl.data.dao.ContentPageDao;
import jp.agentec.abook.abv.bl.data.dao.ContentResourceDao;
import jp.agentec.abook.abv.bl.data.dao.ContentTagDao;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.ContentPageDto;
import jp.agentec.abook.abv.bl.dto.ContentTagDto;
import jp.agentec.abook.abv.bl.dto.comparator.ContentPageDtoComparator;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;

/**
 * @author Lee-mk
 */
public class CommunicationLogic extends AbstractLogic {
	private static final String TAG = "CommunicationLogic";

	private ChatRoomDao chatRoomDao = AbstractDao.getDao(ChatRoomDao.class);
	private ChatMessageDao chatMessageDao = AbstractDao.getDao(ChatMessageDao.class);

	/**
	 * {@link CommunicationLogic} クラスのインスタンスを初期化します。
	 * context　Androidとの互換性の為のプロパティです。Androidの android.content.Context のインスタンスを指定します。<br>
	 * UIがAndroidでない場合、何かのオブジェクトを指定しても、nullと見なします。
	 * @see AbstractLogic
	 * @since 1.2.3.6
	 */
	/*package*/ CommunicationLogic() {
	}

	public String getChatRoomList() {

		List<ChatRoomDto> chatRoomList = chatRoomDao.getAllChatRoom();

		JSONArray resultJsonArray = new JSONArray();
		for (ChatRoomDto chatRoomDto : chatRoomList) {
			Map<String, Object> chatRoomMap = new HashMap<String, Object>();
			chatRoomMap.put("chatRoomId", chatRoomDto.chatRoomId);
			chatRoomMap.put("chatRoomName", chatRoomDto.chatRoomName);
			chatRoomMap.put("type", chatRoomDto.type);
			chatRoomMap.put("favoriteRegisterDate", chatRoomDto.favoriteRegisterDate);
			chatRoomMap.put("unreadCount", chatRoomDto.unreadCount);
			chatRoomMap.put("message", chatRoomDto.message);
			chatRoomMap.put("messageType", chatRoomDto.messageType);
			chatRoomMap.put("insertDate", chatRoomDto.insertDate);
			chatRoomMap.put("userCount", chatRoomDto.userCount);
			JSONObject jsonObject = new JSONObject(chatRoomMap);
			resultJsonArray.put(jsonObject);
		}
		String roomListToStr = resultJsonArray.toString();
		return roomListToStr;
	}

	public void insertChatRoomList(List<ChatRoomDto> roomList) {
		List<ChatMessageDto> insertMessageList = new ArrayList<ChatMessageDto>();
		for (ChatRoomDto chatRoomDto : roomList) {
			if (chatRoomDto.lastMessageInfo != null) {
				insertMessageList.add(chatRoomDto.lastMessageInfo);
			}
		}
		chatRoomDao.insertChatRoom(roomList);
		chatMessageDao.insertChatMessage(insertMessageList);
	}

	public void deleteChatRoomList() {
		chatRoomDao.deleteChatRoom();
	}

}
