package jp.agentec.adf.net.http;

/**
 * ダウンロード状況を示します。
 * @author Taejin Hong
 * @version 1.0.0
 */
public enum HttpDownloadState {
	/**
	 * ダウンロード中、又は開始前の初期状態です。
	 * @since 1.0.0
	 */
	downloading("downloading"),
	/**
	 * 一時中止中です。
	 * @since 1.0.0
	 */
	paused("paused"),
	/**
	 * ダウンロードが終了しました。
	 * @since 1.0.0
	 */
	finished("finished"),
	/**
	 * ダウンロードをキャンセルしました。
	 * @since 1.0.0
	 */
	canceled("canceled"),
	/**
	 * ダウンロードが失敗しました。
	 * @since 1.0.0
	 */
	failed("failed");
	
	private final String state;
	
	HttpDownloadState(String value) {
		this.state = value;
	}
	
	/**
	 * ダウンロード状態を示す文字列を返します。
	 * @return　ダウンロード状態を示す文字列
	 * @since 1.0.0
	 */
	public String state() {
		return state;
	}
}
