package com.theta.network;

/**
 * Device information class
 */
public class ThetaDeviceInfo {
    private String mModel = "";
    private String mDeviceVersion = "";
    private String mSerialNumber = "";
    private String mSSID = "";
    private int mNetworkId = -1;
    /**
     * Constructor
     */
    public ThetaDeviceInfo() {
    }

    /**
     * Acquire model name
     * @return Model name
     */
    public String getModel() {
        return mModel;
    }

    /**
     * Set model name
     * @param model Model name
     */
    public void setModel(String model) {
        mModel = model;
    }

    /**
     * Acquire serial number
     * @return Serial number
     */
    public String getSerialNumber() {
        return mSerialNumber;
    }

    /**
     * Set serial number
     * @param serialNumber Serial number
     */
    public void setSerialNumber(String serialNumber) {
        mSerialNumber = serialNumber;
    }

    /**
     * Acquire firmware version
      * @return Firmware version
     */
    public String getDeviceVersion() {
        return mDeviceVersion;
    }

    /**
     * Set firmware version
     * @param version Firmware version
     */
    public void setDeviceVersion(String version) {
        mDeviceVersion = version;
    }
    /**
     * Acquire SSID
     * @return SSID
     */
    public String getSSID() {
        return mSSID;
    }

    /**
     * Set SSID
     * @param ssid SSID
     */
    public void setSSID(String ssid) {
        mSSID = ssid;
    }

    /**
     * Acquire network ID
     * @return network ID
     */
    public int getNetworkId() {
        return mNetworkId;
    }

    /**
     * Set network ID
     * @param networkId network ID
     */
    public void setNetworkId(int networkId) {
        mNetworkId = networkId;
    }


}
