package jp.agentec.abook.abv.ui.home.activity;

import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.ABVExceptionCode;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.UserAuthenticateLogic;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.adf.util.StringUtil;
import android.content.Context;
import android.os.Bundle;
import android.text.InputType;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.Toast;

public class ChangePasswordActivity extends ABVUIActivity {
	private static final String TAG = "ChangePasswordActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		Logger.i(TAG, "onCreate");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.change_password);
		
		findViewById(R.id.btn_password_change).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
			 	passwordChange();
			}
		});
		
		CheckBox checkBox = (CheckBox) findViewById(R.id.show_password);
		checkBox.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				EditText edtPwdNow = (EditText) findViewById(R.id.edt_pwd_now);
				EditText edtPwdNew = (EditText) findViewById(R.id.edt_pwd_new);
				EditText edtPwdReNew = (EditText) findViewById(R.id.edt_pwd_renew);

				// カーソル位置の保存
				int edtPwdNowSelection = edtPwdNow.getSelectionEnd();
				int edtPwdNewNowSelection = edtPwdNew.getSelectionEnd();
				int edtPwdReNewSelection = edtPwdReNew.getSelectionEnd();

				if (isChecked) {
					Logger.d(TAG, "Password Show ON");
					edtPwdNow.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
					edtPwdNew.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
					edtPwdReNew.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
				} else {
					Logger.d(TAG, "Password Show OFF");
					edtPwdNow.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD);
					edtPwdNew.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD);
					edtPwdReNew.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD);
				}

				// カーソル位置の復元
				edtPwdNow.setSelection(edtPwdNowSelection);
				edtPwdNew.setSelection(edtPwdNewNowSelection);
				edtPwdReNew.setSelection(edtPwdReNewSelection);
			}
		});
		
		findViewById(R.id.close_dialog).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});
	}
	
    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
    	if (keyCode == KeyEvent.KEYCODE_BACK) {
    		finish();
	    } else  {
			return super.onKeyUp(keyCode, event);
		}
    	return false;
    }
	
	private void passwordChange() {
		EditText edtPwdNow = (EditText)findViewById(R.id.edt_pwd_now);
		EditText edtPwdNew = (EditText)findViewById(R.id.edt_pwd_new);
		EditText edtPwdReNew = (EditText)findViewById(R.id.edt_pwd_renew);
		
		InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
		if (StringUtil.isNullOrEmpty(edtPwdNow.getText().toString())) {
			
			edtPwdNow.setError(getString(R.string.E101));
			edtPwdNow.requestFocus();
			imm.showSoftInput(edtPwdNow, InputMethodManager.SHOW_IMPLICIT);
			return;
		}
		if (StringUtil.isNullOrEmpty(edtPwdNew.getText().toString())) {
			edtPwdNew.setError(getString(R.string.E102));
			edtPwdNew.requestFocus();
			imm.showSoftInput(edtPwdNew, InputMethodManager.SHOW_IMPLICIT);
			return;
		}
		if (StringUtil.isNullOrEmpty(edtPwdReNew.getText().toString())) {
			edtPwdReNew.setError(getString(R.string.E103));
			edtPwdReNew.requestFocus();
			imm.showSoftInput(edtPwdReNew, InputMethodManager.SHOW_IMPLICIT);
			return;
		}
		if (!edtPwdNew.getText().toString().endsWith(edtPwdReNew.getText().toString())) {
			edtPwdReNew.setError(getString(R.string.E104));
			edtPwdReNew.requestFocus();
			imm.showSoftInput(edtPwdReNew, InputMethodManager.SHOW_IMPLICIT);
			return;
		}						
		boolean result;
		try {
			UserAuthenticateLogic userservice = AbstractLogic.getLogic(UserAuthenticateLogic.class);
			result = userservice.changePassword(edtPwdNow.getText().toString(),
					edtPwdNew.getText().toString(), true);
			if (result == true) {
				ABVToastUtil.showMakeText(this, getString(R.string.change_password_ok), Toast.LENGTH_LONG);
				finish();
			}
		} catch (NetworkDisconnectedException e) {
			Logger.e("NetworkDisconnectedException", e);
			handleErrorMessageToast(ErrorCode.NETWORK);
		} catch (ABVException e) {
			Logger.e("ABVException", e.toString());
			if (e.getCode().equals(ABVExceptionCode.C_E_SECURITY_1005)) {
				handleErrorMessageToast(ErrorCode.E111);
			}
			else if (e.getCode().equals(ABVExceptionCode.S_E_ACMS_0400)) {
				handleErrorMessageToast(e.getMessage());
			} else {
				handleErrorMessageToast(ErrorMessage.getErrorCode(e));
			}
		} catch (IllegalArgumentException e) {
			Logger.e("IllegalArgumentException", e);
			handleErrorMessageToast(ErrorCode.E110);
		} catch (Exception e) {
			Logger.e("Exception ", e);
			handleErrorMessageToast(ErrorCode.E107);
		}
	}

}
